/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.TransportSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.ExecutorService;

public final class AsyncTransportSettings
extends TransportSettings {
    private final ExecutorService executorService;

    private AsyncTransportSettings(Builder builder) {
        this.executorService = builder.executorService;
    }

    static Builder builder() {
        return new Builder();
    }

    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return "AsyncTransportSettings{executorService=" + this.executorService + '}';
    }

    public static final class Builder {
        private ExecutorService executorService;

        private Builder() {
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = Assertions.notNull("executorService", executorService);
            return this;
        }

        public AsyncTransportSettings build() {
            return new AsyncTransportSettings(this);
        }
    }
}

