/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.Function;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ListCollectionNamesIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.ListCollectionsIterableImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

final class ListCollectionNamesIterableImpl
implements ListCollectionNamesIterable {
    private final ListCollectionsIterableImpl<BsonDocument> wrapped;
    private final MongoIterable<String> wrappedWithMapping;

    ListCollectionNamesIterableImpl(ListCollectionsIterableImpl<BsonDocument> wrapped) {
        this.wrapped = wrapped;
        this.wrappedWithMapping = wrapped.map((TResult collectionDoc) -> collectionDoc.getString("name").getValue());
    }

    @Override
    public ListCollectionNamesIterable filter(@Nullable Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListCollectionNamesIterable maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionNamesIterable batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesIterable authorizedCollections(boolean authorizedCollections) {
        this.wrapped.authorizedCollections(authorizedCollections);
        return this;
    }

    @Override
    public MongoCursor<String> iterator() {
        return this.wrappedWithMapping.iterator();
    }

    @Override
    public MongoCursor<String> cursor() {
        return this.wrappedWithMapping.cursor();
    }

    @Override
    @Nullable
    public String first() {
        return this.wrappedWithMapping.first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<String, U> mapper) {
        return this.wrappedWithMapping.map(mapper);
    }

    @Override
    public <A extends Collection<? super String>> A into(A target) {
        return this.wrappedWithMapping.into(target);
    }

    ListCollectionsIterableImpl<BsonDocument> getWrapped() {
        return this.wrapped;
    }
}

