/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.jol.info;

import io.github.insideranh.stellarprotect.libs.jol.info.AbstractGraphWalker;
import io.github.insideranh.stellarprotect.libs.jol.info.GraphStats;
import io.github.insideranh.stellarprotect.libs.jol.util.ObjectUtils;
import io.github.insideranh.stellarprotect.libs.jol.util.SimpleIdentityHashSet;
import io.github.insideranh.stellarprotect.libs.jol.util.SimpleStack;
import io.github.insideranh.stellarprotect.libs.jol.vm.VM;
import io.github.insideranh.stellarprotect.libs.jol.vm.VirtualMachine;
import java.lang.reflect.Field;

public class GraphStatsWalker
extends AbstractGraphWalker {
    public GraphStats walk(Object ... roots) {
        this.verifyRoots(roots);
        GraphStats data = new GraphStats();
        SimpleIdentityHashSet visited = new SimpleIdentityHashSet();
        SimpleStack<Object> s = new SimpleStack<Object>();
        VirtualMachine vm = VM.current();
        for (Object root : roots) {
            if (!visited.add(root)) continue;
            data.addRecord(vm.sizeOf(root));
            s.push(root);
        }
        while (!s.isEmpty()) {
            Object o = s.pop();
            Class<?> cl = o.getClass();
            if (cl.isArray()) {
                if (cl.getComponentType().isPrimitive()) continue;
                for (Object e : (Object[])o) {
                    if (e == null || !visited.add(e)) continue;
                    data.addRecord(vm.sizeOf(e));
                    s.push(e);
                }
                continue;
            }
            for (Field f : this.getAllReferenceFields(cl)) {
                Object e = ObjectUtils.value(o, f);
                if (e == null || !visited.add(e)) continue;
                data.addRecord(vm.sizeOf(e));
                s.push(e);
            }
        }
        return data;
    }
}

