/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs.pojo;

import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.ClassModelBuilder;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.Convention;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.FieldPropertyAccessor;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PropertyAccessorImpl;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PropertyMetadata;
import io.github.insideranh.stellarprotect.libs.bson.codecs.pojo.PropertyModelBuilder;
import java.lang.reflect.Modifier;

final class ConventionSetPrivateFieldImpl
implements Convention {
    ConventionSetPrivateFieldImpl() {
    }

    @Override
    public void apply(ClassModelBuilder<?> classModelBuilder) {
        for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            if (!(propertyModelBuilder.getPropertyAccessor() instanceof PropertyAccessorImpl)) {
                throw new CodecConfigurationException(String.format("The SET_PRIVATE_FIELDS_CONVENTION is not compatible with propertyModelBuilder instance that have custom implementations of org.bson.codecs.pojo.PropertyAccessor: %s", propertyModelBuilder.getPropertyAccessor().getClass().getName()));
            }
            PropertyAccessorImpl defaultAccessor = (PropertyAccessorImpl)propertyModelBuilder.getPropertyAccessor();
            PropertyMetadata propertyMetaData = defaultAccessor.getPropertyMetadata();
            if (propertyMetaData.isDeserializable() || propertyMetaData.getField() == null || !Modifier.isPrivate(propertyMetaData.getField().getModifiers())) continue;
            this.setPropertyAccessor(propertyModelBuilder);
        }
    }

    private <T> void setPropertyAccessor(PropertyModelBuilder<T> propertyModelBuilder) {
        propertyModelBuilder.propertyAccessor(new FieldPropertyAccessor((PropertyAccessorImpl)propertyModelBuilder.getPropertyAccessor()));
    }
}

