/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.Transformer;
import io.github.insideranh.stellarprotect.libs.bson.UuidRepresentation;
import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.bson.codecs.AbstractCollectionCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeClassMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeCodecMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.ContainerCodecHelper;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.OverridableUuidRepresentationCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import java.util.Collection;

final class CollectionCodec<C extends Collection<Object>>
extends AbstractCollectionCodec<Object, C>
implements OverridableUuidRepresentationCodec<C> {
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    CollectionCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer, Class<C> clazz) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, clazz, UuidRepresentation.UNSPECIFIED);
    }

    private CollectionCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, Class<C> clazz, UuidRepresentation uuidRepresentation) {
        super(clazz);
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<C> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new CollectionCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, this.getEncoderClass(), uuidRepresentation);
    }

    @Override
    Object readValue(BsonReader reader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter writer, Object value, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }
}

