/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.hooks.vault;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.economy.PlayerEconomyEntry;
import io.github.insideranh.stellarprotect.enums.MoneyVarType;
import io.github.insideranh.stellarprotect.hooks.tasks.TaskCanceller;
import io.github.insideranh.stellarprotect.hooks.vault.DefaultVaultHook;
import io.github.insideranh.stellarprotect.utils.StringCleanerUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
extends DefaultVaultHook {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private Economy economy;
    private TaskCanceller taskCanceller;

    @Override
    public void load() {
        if (this.taskCanceller != null) {
            this.taskCanceller.cancel();
        }
        if (this.plugin.getConfigManager().isEconomyDisabled() || this.economy == null) {
            return;
        }
        this.taskCanceller = this.plugin.getStellarTaskHook(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                double balance;
                PlayerProtect playerProtect;
                if (!player.isOnline() || (playerProtect = PlayerProtect.getPlayer(player)) == null || (balance = StringCleanerUtils.limitTo2Decimals(this.economy.getBalance((OfflinePlayer)player))) == playerProtect.getLastEconomyBalance()) continue;
                double difference = balance - playerProtect.getLastEconomyBalance();
                playerProtect.setLastEconomyBalance(balance);
                LoggerCache.addLog(new PlayerEconomyEntry(playerProtect.getPlayerId(), player.getLocation(), MoneyVarType.VAULT, difference));
            }
        }).runTaskTimerAsynchronously(0L, (long)this.plugin.getConfigManager().getEconomyCheckInterval() * 20L);
    }

    @Override
    public void setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider economyProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            return;
        }
        this.economy = (Economy)economyProvider.getProvider();
    }

    @Override
    public void joinPlayer(Player player, PlayerProtect playerProtect) {
        if (!this.plugin.getConfigManager().isEconomyDisabled() && this.economy != null) {
            playerProtect.setLastEconomyBalance(StringCleanerUtils.limitTo2Decimals(this.economy.getBalance((OfflinePlayer)player)));
        }
    }
}

