/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.hooks;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerXKitEventLogEntry
extends LogEntry {
    private final byte eventType;
    private final String kitId;

    public PlayerXKitEventLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.eventType = jsonObject.get("e").getAsByte();
        this.kitId = jsonObject.get("k").getAsString();
    }

    public PlayerXKitEventLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.eventType = jsonObject.get("e").getAsByte();
        this.kitId = jsonObject.get("k").getAsString();
    }

    public PlayerXKitEventLogEntry(long playerId, Location location, byte eventType, String kitId) {
        super(playerId, ActionType.X_KIT_EVENT.getId(), location, System.currentTimeMillis());
        this.eventType = eventType;
        this.kitId = kitId;
    }

    @Override
    public String getDataString() {
        return this.kitId;
    }

    @Override
    public String toSaveJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("e", (Number)this.eventType);
        jsonObject.addProperty("k", this.kitId);
        return jsonObject.toString();
    }

    @Generated
    public byte getEventType() {
        return this.eventType;
    }

    @Generated
    public String getKitId() {
        return this.kitId;
    }
}

