/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.counters.CategoryCounter;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.items.ItemLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTransactionEntry;
import io.github.insideranh.stellarprotect.enums.ActionCategory;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.utils.Debugger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class LoggerCache {
    private static final StellarProtect plugin = StellarProtect.getInstance();
    private static final CacheConfig[] CATEGORY_CONFIGS_ARRAY = LoggerCache.createCategoryConfigsArray();
    private static final FixedSizeCircularBuffer[] unSavedLogsByCategory = new FixedSizeCircularBuffer[ActionCategory.values().length];
    private static final ConcurrentHashMap<LocationCache, LogRingBuffer>[] cachedLogsByCategory = new ConcurrentHashMap[ActionCategory.values().length];
    private static final TimestampedHashMap<LocationCache, PlayerBlockLogEntry> placedBlockLogs = new TimestampedHashMap(1024, 30000L);
    private static final Cache<String, CachedQuery> queryCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private static final Cache<String, Long> countCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(500L).build();
    private static final ActionCategory[] ACTION_TO_CATEGORY_CACHE;
    private static final CategoryCounter[] categoryCounters;
    private static final AtomicLong totalLogsProcessed;
    private static final AtomicInteger cacheHits;
    private static final AtomicInteger cacheMisses;
    private static final ThreadLocal<StringBuilder> STRING_BUILDER_POOL;
    private static final ThreadLocal<ArrayList<LogEntry>> LOG_LIST_POOL;
    private static final ThreadLocal<HashSet<Integer>> ACTION_ID_SET_POOL;

    private static CacheConfig[] createCategoryConfigsArray() {
        ActionCategory[] categories = ActionCategory.values();
        CacheConfig[] configs = new CacheConfig[categories.length];
        configs[ActionCategory.BLOCK_ACTIONS.ordinal()] = new CacheConfig(1000, 5, 300000L);
        configs[ActionCategory.ITEM_ACTIONS.ordinal()] = new CacheConfig(800, 30, 600000L);
        configs[ActionCategory.ENTITY_ACTIONS.ordinal()] = new CacheConfig(400, 20, 900000L);
        configs[ActionCategory.PLAYER_ACTIONS.ordinal()] = new CacheConfig(200, 5, 1800000L);
        configs[ActionCategory.SYSTEM_ACTIONS.ordinal()] = new CacheConfig(100, 10, 1800000L);
        configs[ActionCategory.COMMUNICATION_ACTIONS.ordinal()] = new CacheConfig(100, 15, 1200000L);
        configs[ActionCategory.FLUID_ACTIONS.ordinal()] = new CacheConfig(600, 10, 720000L);
        configs[ActionCategory.INVENTORY_ACTIONS.ordinal()] = new CacheConfig(2000, 40, 300000L);
        configs[ActionCategory.SESSION_ACTIONS.ordinal()] = new CacheConfig(100, 10, 1800000L);
        configs[ActionCategory.SIGN_ACTIONS.ordinal()] = new CacheConfig(100, 10, 1800000L);
        configs[ActionCategory.HOOK_ACTIONS.ordinal()] = new CacheConfig(300, 10, 300000L);
        configs[ActionCategory.WORLD_ACTIONS.ordinal()] = new CacheConfig(100, 2, 1800000L);
        configs[ActionCategory.UNKNOWN_ACTIONS.ordinal()] = new CacheConfig(500, 10, 300000L);
        return configs;
    }

    private static void initializeCaches() {
        ActionCategory[] categories;
        for (ActionCategory category : categories = ActionCategory.values()) {
            int categoryOrdinal = category.ordinal();
            for (ActionType actionType : category.getActionSet()) {
                LoggerCache.ACTION_TO_CATEGORY_CACHE[actionType.getId()] = category;
            }
            CacheConfig config = CATEGORY_CONFIGS_ARRAY[categoryOrdinal];
            LoggerCache.unSavedLogsByCategory[categoryOrdinal] = new FixedSizeCircularBuffer(config.batchSize * 2);
            LoggerCache.cachedLogsByCategory[categoryOrdinal] = new ConcurrentHashMap(1024, 0.75f, 16);
            LoggerCache.categoryCounters[categoryOrdinal] = new CategoryCounter(config.batchSize);
        }
    }

    private static void startCleanupScheduler() {
        plugin.getStellarTaskHook(() -> {
            LoggerCache.clearRamCache();
            LoggerCache.cleanQueryCache();
        }).runTaskTimerAsynchronously(6000L, 6000L);
    }

    public static void addLog(LogEntry logEntry) {
        ActionCategory category = LoggerCache.getCategoryByActionId(logEntry.getActionType());
        int categoryOrdinal = category.ordinal();
        LocationCache location = logEntry.asLocation();
        unSavedLogsByCategory[categoryOrdinal].add(logEntry);
        ConcurrentHashMap<LocationCache, LogRingBuffer> categoryCache = cachedLogsByCategory[categoryOrdinal];
        LogRingBuffer buffer = categoryCache.get(location);
        if (buffer == null) {
            CacheConfig config = CATEGORY_CONFIGS_ARRAY[categoryOrdinal];
            buffer = new LogRingBuffer(config.maxLogsPerLocation);
            LogRingBuffer existing = categoryCache.putIfAbsent(location, buffer);
            if (existing != null) {
                buffer = existing;
            }
        }
        buffer.add(logEntry);
        if (logEntry instanceof PlayerBlockLogEntry && logEntry.getActionType() == ActionType.BLOCK_PLACE.getId()) {
            placedBlockLogs.put(location, (PlayerBlockLogEntry)logEntry);
        }
        totalLogsProcessed.incrementAndGet();
        CategoryCounter counter = categoryCounters[categoryOrdinal];
        if (counter.incrementAndCheckThreshold()) {
            StellarProtect.getInstance().getCacheManager().forceSave(category);
            counter.reset();
        }
    }

    private static ActionCategory getCategoryByActionId(int actionTypeId) {
        if (actionTypeId >>> 31 == 0 && actionTypeId < ACTION_TO_CATEGORY_CACHE.length) {
            ActionCategory category = ACTION_TO_CATEGORY_CACHE[actionTypeId];
            return category != null ? category : ActionCategory.SYSTEM_ACTIONS;
        }
        return ActionCategory.SYSTEM_ACTIONS;
    }

    public static List<LogEntry> getFlushLogsToDatabase() {
        ActionCategory[] categories;
        ArrayList<LogEntry> allBatch = LOG_LIST_POOL.get();
        allBatch.clear();
        for (ActionCategory category : categories = ActionCategory.values()) {
            List<LogEntry> categoryBatch = LoggerCache.getFlushLogsToDatabase(category);
            allBatch.addAll(categoryBatch);
        }
        Debugger.debugSave("Flushing " + allBatch.size() + " logs to database.");
        return new ArrayList<LogEntry>(allBatch);
    }

    public static List<LogEntry> getFlushLogsToDatabase(ActionCategory category) {
        int categoryOrdinal = category.ordinal();
        CacheConfig config = CATEGORY_CONFIGS_ARRAY[categoryOrdinal];
        return unSavedLogsByCategory[categoryOrdinal].drainBatch(config.batchSize);
    }

    public static List<ItemLogEntry> getChestTransactions(Location location, int skip, int limit) {
        LocationCache locationCache = LocationCache.of(location);
        LogRingBuffer logs = cachedLogsByCategory[ActionCategory.INVENTORY_ACTIONS.ordinal()].get(locationCache);
        if (logs == null || logs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allItems = new ArrayList(limit * 2);
        logs.forEachReverse(log -> {
            if (!(log instanceof PlayerTransactionEntry)) {
                return;
            }
            PlayerTransactionEntry transaction = (PlayerTransactionEntry)log;
            transaction.getAdded().forEach((templateId, amount) -> {
                ItemTemplate itemTemplate = plugin.getItemsManager().getItemTemplate((long)templateId);
                ItemStack item = itemTemplate.getBukkitItem();
                if (item != null) {
                    allItems.add(new ItemLogEntry(item, log.getPlayerId(), (int)amount, true, log.getCreatedAt()));
                }
            });
            transaction.getRemoved().forEach((templateId, amount) -> {
                ItemTemplate itemTemplate = plugin.getItemsManager().getItemTemplate((long)templateId);
                ItemStack item = itemTemplate.getBukkitItem();
                if (item != null) {
                    allItems.add(new ItemLogEntry(item, log.getPlayerId(), (int)amount, false, log.getCreatedAt()));
                }
            });
        });
        allItems.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        if (skip >= allItems.size()) {
            return Collections.emptyList();
        }
        int toIndex = Math.min(skip + limit, allItems.size());
        return allItems.subList(skip, toIndex);
    }

    public static List<LogEntry> getLogs(LocationCache location, int skip, int limit) {
        ArrayList<LogEntry> allLogs = new ArrayList<LogEntry>(limit * 2);
        ActionCategory[] categories = ActionCategory.values();
        for (int i = 0; i < categories.length; ++i) {
            LogRingBuffer categoryLogs = cachedLogsByCategory[i].get(location);
            if (categoryLogs == null || categoryLogs.isEmpty()) continue;
            categoryLogs.addAllTo(allLogs);
        }
        allLogs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        if (skip >= allLogs.size()) {
            return Collections.emptyList();
        }
        int toIndex = Math.min(skip + limit, allLogs.size());
        return allLogs.subList(skip, toIndex);
    }

    public static List<LogEntry> getLogs(DatabaseFilters databaseFilters, int skip, int limit) {
        List<LogEntry> paginatedLogs;
        TimeArg timeArg = databaseFilters.getTimeFilter();
        RadiusArg radiusArg = databaseFilters.getRadiusFilter();
        List<Integer> actionTypeIds = databaseFilters.getActionTypesFilter();
        List<Long> worldsFilter = databaseFilters.getAllIncludeFilters();
        List<Long> worldsExcludeFilter = databaseFilters.getAllExcludeFilters();
        UsersArg usersArg = databaseFilters.getUserFilters();
        StringBuilder keyBuilder = STRING_BUILDER_POOL.get();
        keyBuilder.setLength(0);
        if (timeArg != null) {
            keyBuilder.append(timeArg.getStart()).append('_').append(timeArg.getEnd());
        } else {
            keyBuilder.append("NOTIME");
        }
        keyBuilder.append('_');
        if (radiusArg != null) {
            keyBuilder.append(radiusArg);
        } else {
            keyBuilder.append("NORADIUS");
        }
        keyBuilder.append('_');
        if (!actionTypeIds.isEmpty()) {
            for (int i = 0; i < actionTypeIds.size(); ++i) {
                if (i > 0) {
                    keyBuilder.append(',');
                }
                keyBuilder.append(actionTypeIds.get(i));
            }
        } else {
            keyBuilder.append("ALL");
        }
        keyBuilder.append('_');
        if (!usersArg.getUserIds().isEmpty()) {
            usersArg.getUserIds().forEach(userId -> keyBuilder.append(userId).append(','));
        } else {
            keyBuilder.append("ALL");
        }
        keyBuilder.append('_');
        if (!worldsFilter.isEmpty()) {
            worldsFilter.forEach(world -> keyBuilder.append(world).append(','));
        } else {
            keyBuilder.append("ALL");
        }
        keyBuilder.append('_');
        if (!worldsExcludeFilter.isEmpty()) {
            worldsExcludeFilter.forEach(world -> keyBuilder.append(world).append(','));
        } else {
            keyBuilder.append("ALL");
        }
        keyBuilder.append('_').append(skip).append('_').append(limit);
        String cacheKey = keyBuilder.toString();
        CachedQuery cached = (CachedQuery)queryCache.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isExpired()) {
            cacheHits.incrementAndGet();
            return cached.getLogs();
        }
        cacheMisses.incrementAndGet();
        HashSet<Integer> actionIds = ACTION_ID_SET_POOL.get();
        actionIds.clear();
        actionIds.addAll(actionTypeIds);
        ArrayList<LogEntry> logs = LOG_LIST_POOL.get();
        logs.clear();
        Set<ActionCategory> categoriesToSearch = LoggerCache.determineCategoriesToSearch(actionTypeIds);
        long timeStart = timeArg != null ? timeArg.getStart() : Long.MIN_VALUE;
        long timeEnd = timeArg != null ? timeArg.getEnd() : Long.MAX_VALUE;
        Set<Long> userIds = usersArg.getUserIds();
        boolean hasUserFilter = !userIds.isEmpty();
        boolean hasActionFilter = !actionTypeIds.isEmpty();
        for (ActionCategory category : categoriesToSearch) {
            int categoryOrdinal = category.ordinal();
            ConcurrentHashMap<LocationCache, LogRingBuffer> categoryCache = cachedLogsByCategory[categoryOrdinal];
            categoryCache.forEach((locationCache, ringBuffer) -> {
                if (radiusArg != null && !locationCache.isInside(radiusArg.getWorldId(), radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) {
                    return;
                }
                ringBuffer.forEachIf(log -> {
                    long createdAt = log.getCreatedAt();
                    if (createdAt < timeStart || createdAt > timeEnd) {
                        return false;
                    }
                    if (hasActionFilter && !actionIds.contains(log.getActionType())) {
                        return false;
                    }
                    return !hasUserFilter || userIds.contains(log.getPlayerId());
                }, logs);
            });
        }
        logs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        if (skip >= logs.size()) {
            paginatedLogs = Collections.emptyList();
        } else {
            int toIndex = Math.min(skip + limit, logs.size());
            paginatedLogs = new ArrayList<LogEntry>(logs.subList(skip, toIndex));
        }
        if (skip == 0 && limit <= 100) {
            queryCache.put((Object)cacheKey, (Object)new CachedQuery(paginatedLogs, System.currentTimeMillis() + 300000L));
        }
        return paginatedLogs;
    }

    private static Set<ActionCategory> determineCategoriesToSearch(List<Integer> actionTypeIds) {
        if (actionTypeIds.isEmpty()) {
            return EnumSet.allOf(ActionCategory.class);
        }
        EnumSet<ActionCategory> categories = EnumSet.noneOf(ActionCategory.class);
        for (int actionId : actionTypeIds) {
            ActionCategory category = LoggerCache.getCategoryByActionId(actionId);
            categories.add(category);
        }
        return categories;
    }

    public static List<LogEntry> getLogs(Location location, int skip, int limit) {
        return LoggerCache.getLogs(LocationCache.of(location), skip, limit);
    }

    public static LogEntry getPlacedBlockLog(Location location) {
        return (LogEntry)placedBlockLogs.get(LocationCache.of(location));
    }

    public static void clearRamCache() {
        long currentTime = System.currentTimeMillis();
        ActionCategory[] categories = ActionCategory.values();
        for (int i = 0; i < categories.length; ++i) {
            CacheConfig config = CATEGORY_CONFIGS_ARRAY[i];
            long timeLimit = currentTime - config.cacheRetentionTime;
            ConcurrentHashMap<LocationCache, LogRingBuffer> categoryCache = cachedLogsByCategory[i];
            categoryCache.entrySet().removeIf(entry -> {
                LogRingBuffer buffer = (LogRingBuffer)entry.getValue();
                buffer.removeOldEntries(timeLimit);
                return buffer.isEmpty();
            });
        }
        placedBlockLogs.cleanup(currentTime);
    }

    private static void cleanQueryCache() {
        queryCache.cleanUp();
        countCache.cleanUp();
    }

    @Deprecated
    public static List<LogEntry> getLogs(TimeArg timeArg, RadiusArg radiusArg, ActionType actionType, int skip, int limit) {
        return LoggerCache.getLogs(timeArg, radiusArg, actionType != null ? Collections.singletonList(actionType) : Collections.emptyList(), skip, limit);
    }

    @Deprecated
    public static List<LogEntry> getLogs(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes, int skip, int limit) {
        List<LogEntry> paginatedLogs;
        EnumSet<ActionCategory> categoriesToSearch;
        StringBuilder keyBuilder = STRING_BUILDER_POOL.get();
        keyBuilder.setLength(0);
        keyBuilder.append(timeArg.getStart()).append('_').append(timeArg.getEnd()).append('_').append(radiusArg.toString()).append('_');
        if (!actionTypes.isEmpty()) {
            for (int i = 0; i < actionTypes.size(); ++i) {
                if (i > 0) {
                    keyBuilder.append(',');
                }
                keyBuilder.append(actionTypes.get(i).name());
            }
        } else {
            keyBuilder.append("ALL");
        }
        keyBuilder.append('_').append(skip).append('_').append(limit);
        String cacheKey = keyBuilder.toString();
        CachedQuery cached = (CachedQuery)queryCache.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isExpired()) {
            cacheHits.incrementAndGet();
            return cached.getLogs();
        }
        cacheMisses.incrementAndGet();
        HashSet<Integer> actionIds = ACTION_ID_SET_POOL.get();
        actionIds.clear();
        for (ActionType actionType : actionTypes) {
            actionIds.add(actionType.getId());
        }
        ArrayList<LogEntry> logs = LOG_LIST_POOL.get();
        logs.clear();
        if (actionTypes.isEmpty()) {
            categoriesToSearch = EnumSet.allOf(ActionCategory.class);
        } else {
            categoriesToSearch = EnumSet.noneOf(ActionCategory.class);
            for (ActionType actionType : actionTypes) {
                ActionCategory category = LoggerCache.getCategoryByActionId(actionType.getId());
                categoriesToSearch.add(category);
            }
        }
        long timeStart = timeArg.getStart();
        long timeEnd = timeArg.getEnd();
        boolean hasActionFilter = !actionTypes.isEmpty();
        for (ActionCategory category : categoriesToSearch) {
            int categoryOrdinal = category.ordinal();
            ConcurrentHashMap<LocationCache, LogRingBuffer> categoryCache = cachedLogsByCategory[categoryOrdinal];
            categoryCache.forEach((locationCache, ringBuffer) -> {
                if (!locationCache.isInside(radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) {
                    return;
                }
                ringBuffer.forEachIf(log -> {
                    long createdAt = log.getCreatedAt();
                    boolean timeValid = createdAt >= timeStart & createdAt <= timeEnd;
                    boolean actionValid = !hasActionFilter || actionIds.contains(log.getActionType());
                    return timeValid & actionValid;
                }, logs);
            });
        }
        logs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        if (skip >= logs.size()) {
            paginatedLogs = Collections.emptyList();
        } else {
            int toIndex = Math.min(skip + limit, logs.size());
            paginatedLogs = new ArrayList<LogEntry>(logs.subList(skip, toIndex));
        }
        if (skip == 0 && limit <= 100) {
            queryCache.put((Object)cacheKey, (Object)new CachedQuery(paginatedLogs, System.currentTimeMillis() + 300000L));
        }
        return paginatedLogs;
    }

    public static long countLogs(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes) {
        EnumSet<ActionCategory> categoriesToSearch;
        StringBuilder keyBuilder = STRING_BUILDER_POOL.get();
        keyBuilder.setLength(0);
        keyBuilder.append("COUNT_").append(timeArg.getStart()).append('_').append(timeArg.getEnd()).append('_').append(radiusArg.toString()).append('_');
        if (!actionTypes.isEmpty()) {
            for (int i = 0; i < actionTypes.size(); ++i) {
                if (i > 0) {
                    keyBuilder.append(',');
                }
                keyBuilder.append(actionTypes.get(i).name());
            }
        } else {
            keyBuilder.append("ALL");
        }
        String countCacheKey = keyBuilder.toString();
        Long cached = (Long)countCache.getIfPresent((Object)countCacheKey);
        if (cached != null) {
            cacheHits.incrementAndGet();
            return cached;
        }
        cacheMisses.incrementAndGet();
        HashSet<Integer> actionIds = ACTION_ID_SET_POOL.get();
        actionIds.clear();
        for (ActionType actionType : actionTypes) {
            actionIds.add(actionType.getId());
        }
        if (actionTypes.isEmpty()) {
            categoriesToSearch = EnumSet.allOf(ActionCategory.class);
        } else {
            categoriesToSearch = EnumSet.noneOf(ActionCategory.class);
            for (ActionType actionType : actionTypes) {
                ActionCategory category = LoggerCache.getCategoryByActionId(actionType.getId());
                categoriesToSearch.add(category);
            }
        }
        long l = 0L;
        long timeStart = timeArg.getStart();
        long timeEnd = timeArg.getEnd();
        boolean hasActionFilter = !actionTypes.isEmpty();
        for (ActionCategory category : categoriesToSearch) {
            int categoryOrdinal = category.ordinal();
            ConcurrentHashMap<LocationCache, LogRingBuffer> categoryCache = cachedLogsByCategory[categoryOrdinal];
            for (Map.Entry<LocationCache, LogRingBuffer> entry : categoryCache.entrySet()) {
                LocationCache cache = entry.getKey();
                if (!cache.isInside(radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) continue;
                LogRingBuffer buffer = entry.getValue();
                l += buffer.countMatching(timeStart, timeEnd, hasActionFilter ? actionIds : null);
            }
        }
        countCache.put((Object)countCacheKey, (Object)l);
        return l;
    }

    @Generated
    public static CacheConfig[] getCATEGORY_CONFIGS_ARRAY() {
        return CATEGORY_CONFIGS_ARRAY;
    }

    @Generated
    public static FixedSizeCircularBuffer[] getUnSavedLogsByCategory() {
        return unSavedLogsByCategory;
    }

    @Generated
    public static ConcurrentHashMap<LocationCache, LogRingBuffer>[] getCachedLogsByCategory() {
        return cachedLogsByCategory;
    }

    @Generated
    public static TimestampedHashMap<LocationCache, PlayerBlockLogEntry> getPlacedBlockLogs() {
        return placedBlockLogs;
    }

    @Generated
    public static Cache<String, CachedQuery> getQueryCache() {
        return queryCache;
    }

    static {
        categoryCounters = new CategoryCounter[ActionCategory.values().length];
        totalLogsProcessed = new AtomicLong(0L);
        cacheHits = new AtomicInteger(0);
        cacheMisses = new AtomicInteger(0);
        STRING_BUILDER_POOL = ThreadLocal.withInitial(() -> new StringBuilder(256));
        LOG_LIST_POOL = ThreadLocal.withInitial(() -> new ArrayList(1000));
        ACTION_ID_SET_POOL = ThreadLocal.withInitial(() -> new HashSet(64));
        int maxActionId = Arrays.stream(ActionType.values()).mapToInt(ActionType::getId).max().orElse(0);
        ACTION_TO_CATEGORY_CACHE = new ActionCategory[maxActionId + 1];
        LoggerCache.initializeCaches();
        LoggerCache.startCleanupScheduler();
    }

    private static class CacheConfig {
        final int batchSize;
        final int maxLogsPerLocation;
        final long cacheRetentionTime;

        CacheConfig(int batchSize, int maxLogsPerLocation, long cacheRetentionTime) {
            this.batchSize = batchSize;
            this.maxLogsPerLocation = maxLogsPerLocation;
            this.cacheRetentionTime = cacheRetentionTime;
        }
    }

    private static class FixedSizeCircularBuffer {
        private final LogEntry[] buffer;
        private final int capacity;
        private final StampedLock lock = new StampedLock();
        private volatile int writeIndex = 0;
        private volatile int readIndex = 0;
        private volatile int size = 0;

        public FixedSizeCircularBuffer(int capacity) {
            this.capacity = capacity;
            this.buffer = new LogEntry[capacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(LogEntry entry) {
            long stamp = this.lock.writeLock();
            try {
                if (this.size < this.capacity) {
                    this.buffer[this.writeIndex] = entry;
                    this.writeIndex = (this.writeIndex + 1) % this.capacity;
                    ++this.size;
                } else {
                    this.buffer[this.writeIndex] = entry;
                    this.writeIndex = (this.writeIndex + 1) % this.capacity;
                    this.readIndex = (this.readIndex + 1) % this.capacity;
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<LogEntry> drainBatch(int batchSize) {
            long stamp = this.lock.writeLock();
            try {
                int actualBatch = Math.min(batchSize, this.size);
                ArrayList<LogEntry> batch = new ArrayList<LogEntry>(actualBatch);
                for (int i = 0; i < actualBatch; ++i) {
                    batch.add(this.buffer[this.readIndex]);
                    this.buffer[this.readIndex] = null;
                    this.readIndex = (this.readIndex + 1) % this.capacity;
                }
                this.size -= actualBatch;
                ArrayList<LogEntry> arrayList = batch;
                return arrayList;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    private static class LogRingBuffer {
        private final LogEntry[] buffer;
        private final int capacity;
        private final StampedLock lock = new StampedLock();
        private volatile int head = 0;
        private volatile int size = 0;

        public LogRingBuffer(int capacity) {
            this.capacity = capacity;
            this.buffer = new LogEntry[capacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(LogEntry entry) {
            long stamp = this.lock.writeLock();
            try {
                if (this.size < this.capacity) {
                    this.buffer[(this.head + this.size) % this.capacity] = entry;
                    ++this.size;
                } else {
                    this.buffer[this.head] = entry;
                    this.head = (this.head + 1) % this.capacity;
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            boolean empty;
            long stamp = this.lock.tryOptimisticRead();
            boolean bl = empty = this.size == 0;
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                try {
                    empty = this.size == 0;
                }
                finally {
                    this.lock.unlockRead(stamp);
                }
            }
            return empty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEachReverse(Consumer<LogEntry> consumer) {
            long stamp = this.lock.readLock();
            try {
                for (int i = this.size - 1; i >= 0; --i) {
                    LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                    if (entry == null) continue;
                    consumer.accept(entry);
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAllTo(List<LogEntry> list) {
            long stamp = this.lock.readLock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                    if (entry == null) continue;
                    list.add(entry);
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEachIf(Predicate<LogEntry> filter, List<LogEntry> collector) {
            long stamp = this.lock.readLock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                    if (entry == null || !filter.test(entry)) continue;
                    collector.add(entry);
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOldEntries(long timeLimit) {
            long stamp = this.lock.writeLock();
            try {
                int removed = 0;
                for (int i = 0; i < this.size; ++i) {
                    LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                    if (entry == null || entry.getCreatedAt() >= timeLimit) continue;
                    this.buffer[(this.head + i) % this.capacity] = null;
                    ++removed;
                }
                if (removed > 0) {
                    int i;
                    int newIndex = 0;
                    for (i = 0; i < this.size; ++i) {
                        LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                        if (entry == null) continue;
                        this.buffer[newIndex] = entry;
                        ++newIndex;
                    }
                    for (i = newIndex; i < this.size; ++i) {
                        this.buffer[i] = null;
                    }
                    this.size -= removed;
                    this.head = 0;
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long countMatching(long timeStart, long timeEnd, Set<Integer> actionIds) {
            long count = 0L;
            long stamp = this.lock.readLock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    long createdAt;
                    LogEntry entry = this.buffer[(this.head + i) % this.capacity];
                    if (entry == null || (createdAt = entry.getCreatedAt()) < timeStart || createdAt > timeEnd || actionIds != null && !actionIds.contains(entry.getActionType())) continue;
                    ++count;
                }
            }
            finally {
                this.lock.unlockRead(stamp);
            }
            return count;
        }
    }

    private static class TimestampedHashMap<K, V>
    extends ConcurrentHashMap<K, V> {
        private final long ttl;
        private final ConcurrentHashMap<K, Long> timestamps;

        public TimestampedHashMap(int initialCapacity, long ttlMillis) {
            super(initialCapacity);
            this.ttl = ttlMillis;
            this.timestamps = new ConcurrentHashMap(initialCapacity);
        }

        @Override
        public V put(K key, V value) {
            this.timestamps.put(key, System.currentTimeMillis());
            return super.put(key, value);
        }

        public void cleanup(long currentTime) {
            this.timestamps.entrySet().removeIf(entry -> {
                boolean expired;
                boolean bl = expired = currentTime - (Long)entry.getValue() > this.ttl;
                if (expired) {
                    super.remove(entry.getKey());
                }
                return expired;
            });
        }
    }

    private static class CachedQuery {
        private final List<LogEntry> logs;
        private final long expireTime;

        public CachedQuery(List<LogEntry> logs, long expireTime) {
            this.logs = logs;
            this.expireTime = expireTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public long getExpireTime() {
            return this.expireTime;
        }
    }
}

