/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import com.google.common.collect.Sets;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import io.github.insideranh.stellarprotect.blocks.DataBlock;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class BlocksManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final Map<String, BlockTemplate> blockHashToId = new ConcurrentHashMap<String, BlockTemplate>(100);
    private final Map<Integer, BlockTemplate> idToBlockTemplate = new ConcurrentHashMap<Integer, BlockTemplate>(100);
    private final Set<Integer> unsavedBlocks = Sets.newConcurrentHashSet();
    private final AtomicInteger currentId = new AtomicInteger(0);

    public void load() {
    }

    public BlockTemplate getBlockTemplate(int id) {
        return this.idToBlockTemplate.get(id);
    }

    public void loadBlockData(int id, String blockDataString) {
        DataBlock dataBlock = this.plugin.getDataBlock(blockDataString);
        BlockTemplate template = new BlockTemplate(id, dataBlock);
        this.blockHashToId.put(blockDataString, template);
        this.idToBlockTemplate.put(template.getId(), template);
    }

    public BlockTemplate getBlockTemplate(String blockDataString) {
        DataBlock dataBlock = this.plugin.getDataBlock(blockDataString);
        BlockTemplate id = this.blockHashToId.get(blockDataString);
        if (id != null) {
            return id;
        }
        return this.createBlockTemplate(dataBlock);
    }

    public BlockTemplate getBlockTemplate(BlockState block) {
        String blockDataString = this.plugin.getProtectNMS().getBlockData(block);
        BlockTemplate id = this.blockHashToId.get(blockDataString);
        if (id != null) {
            return id;
        }
        DataBlock dataBlock = this.plugin.getDataBlock(block);
        return this.createBlockTemplate(dataBlock);
    }

    public BlockTemplate getBlockTemplate(Block block) {
        String blockDataString = this.plugin.getProtectNMS().getBlockData(block);
        BlockTemplate id = this.blockHashToId.get(blockDataString);
        if (id != null) {
            return id;
        }
        DataBlock dataBlock = this.plugin.getDataBlock(block);
        return this.createBlockTemplate(dataBlock);
    }

    public BlockTemplate createBlockTemplate(DataBlock dataBlock) {
        int id = this.currentId.getAndIncrement();
        BlockTemplate template = new BlockTemplate(id, dataBlock);
        this.unsavedBlocks.add(id);
        this.blockHashToId.put(dataBlock.getBlockDataString(), template);
        this.idToBlockTemplate.put(id, template);
        return template;
    }

    public void saveBlocks() {
        if (this.unsavedBlocks.isEmpty()) {
            return;
        }
        ArrayList<BlockTemplate> templates = new ArrayList<BlockTemplate>();
        this.unsavedBlocks.forEach(id -> templates.add(this.idToBlockTemplate.get(id)));
        this.unsavedBlocks.clear();
        this.plugin.getProtectDatabase().saveBlocks(templates);
    }

    public int getBlockDataCount() {
        return this.blockHashToId.size();
    }

    @Generated
    public StellarProtect getPlugin() {
        return this.plugin;
    }

    @Generated
    public Map<String, BlockTemplate> getBlockHashToId() {
        return this.blockHashToId;
    }

    @Generated
    public Map<Integer, BlockTemplate> getIdToBlockTemplate() {
        return this.idToBlockTemplate;
    }

    @Generated
    public Set<Integer> getUnsavedBlocks() {
        return this.unsavedBlocks;
    }

    @Generated
    public AtomicInteger getCurrentId() {
        return this.currentId;
    }
}

