/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.validator;

import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.validator.NoOpFieldNameValidator;

public final class UpdateFieldNameValidator
implements FieldNameValidator {
    private boolean encounteredField = false;

    @Override
    public boolean validate(String fieldName) {
        this.encounteredField = true;
        return fieldName.startsWith("$");
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(fieldName.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return NoOpFieldNameValidator.INSTANCE;
    }

    @Override
    public void start() {
        this.reset();
    }

    @Override
    public void end() {
        if (!this.encounteredField) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }

    public UpdateFieldNameValidator reset() {
        this.encounteredField = false;
        return this;
    }
}

