/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.selector;

import io.github.insideranh.stellarprotect.libs.mongodb.annotations.ThreadSafe;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.selector.ServerSelector;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@ThreadSafe
public final class MinimumOperationCountServerSelector
implements ServerSelector {
    private final Cluster.ServersSnapshot serversSnapshot;

    public MinimumOperationCountServerSelector(Cluster.ServersSnapshot serversSnapshot) {
        this.serversSnapshot = serversSnapshot;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().min(Comparator.comparingInt(serverDescription -> Assertions.assertNotNull(this.serversSnapshot.getServer(serverDescription.getAddress())).operationCount())).map(Collections::singletonList).orElse(Collections.emptyList());
    }
}

