/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonDouble;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.CreateIndexCommitQuorum;
import io.github.insideranh.stellarprotect.libs.mongodb.DuplicateKeyException;
import io.github.insideranh.stellarprotect.libs.mongodb.ErrorCategory;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcernResult;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.WriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.IndexRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.IndexHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ServerVersionHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CreateIndexesOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final List<IndexRequest> requests;
    private final WriteConcern writeConcern;
    private CreateIndexCommitQuorum commitQuorum;

    public CreateIndexesOperation(MongoNamespace namespace, List<IndexRequest> requests, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.requests = Assertions.notNull("indexRequests", requests);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public List<IndexRequest> getRequests() {
        return this.requests;
    }

    public List<String> getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>(this.requests.size());
        for (IndexRequest request : this.requests) {
            if (request.getName() != null) {
                indexNames.add(request.getName());
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(request.getKeys()));
        }
        return indexNames;
    }

    public CreateIndexCommitQuorum getCommitQuorum() {
        return this.commitQuorum;
    }

    public CreateIndexesOperation commitQuorum(@Nullable CreateIndexCommitQuorum commitQuorum) {
        this.commitQuorum = commitQuorum;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            return SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(binding.getOperationContext().getTimeoutContext()));
        }
        catch (MongoCommandException e) {
            throw this.checkForDuplicateKeyError(e);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(binding.getOperationContext().getTimeoutContext()), (result, t) -> {
            if (t != null) {
                callback.onResult(null, this.translateException(t));
            } else {
                callback.onResult((Void)result, null);
            }
        });
    }

    private BsonDocument getIndex(IndexRequest request) {
        BsonDocument index = new BsonDocument();
        index.append("key", request.getKeys());
        index.append("name", new BsonString(request.getName() != null ? request.getName() : IndexHelper.generateIndexName(request.getKeys())));
        if (request.isBackground()) {
            index.append("background", BsonBoolean.TRUE);
        }
        if (request.isUnique()) {
            index.append("unique", BsonBoolean.TRUE);
        }
        if (request.isSparse()) {
            index.append("sparse", BsonBoolean.TRUE);
        }
        if (request.getExpireAfter(TimeUnit.SECONDS) != null) {
            index.append("expireAfterSeconds", new BsonInt64(Assertions.assertNotNull(request.getExpireAfter(TimeUnit.SECONDS))));
        }
        if (request.getVersion() != null) {
            index.append("v", new BsonInt32(Assertions.assertNotNull(request.getVersion())));
        }
        if (request.getWeights() != null) {
            index.append("weights", Assertions.assertNotNull(request.getWeights()));
        }
        if (request.getDefaultLanguage() != null) {
            index.append("default_language", new BsonString(Assertions.assertNotNull(request.getDefaultLanguage())));
        }
        if (request.getLanguageOverride() != null) {
            index.append("language_override", new BsonString(Assertions.assertNotNull(request.getLanguageOverride())));
        }
        if (request.getTextVersion() != null) {
            index.append("textIndexVersion", new BsonInt32(Assertions.assertNotNull(request.getTextVersion())));
        }
        if (request.getSphereVersion() != null) {
            index.append("2dsphereIndexVersion", new BsonInt32(Assertions.assertNotNull(request.getSphereVersion())));
        }
        if (request.getBits() != null) {
            index.append("bits", new BsonInt32(Assertions.assertNotNull(request.getBits())));
        }
        if (request.getMin() != null) {
            index.append("min", new BsonDouble(Assertions.assertNotNull(request.getMin())));
        }
        if (request.getMax() != null) {
            index.append("max", new BsonDouble(Assertions.assertNotNull(request.getMax())));
        }
        if (request.getDropDups()) {
            index.append("dropDups", BsonBoolean.TRUE);
        }
        if (request.getStorageEngine() != null) {
            index.append("storageEngine", Assertions.assertNotNull(request.getStorageEngine()));
        }
        if (request.getPartialFilterExpression() != null) {
            index.append("partialFilterExpression", Assertions.assertNotNull(request.getPartialFilterExpression()));
        }
        if (request.getCollation() != null) {
            index.append("collation", Assertions.assertNotNull(request.getCollation().asDocument()));
        }
        if (request.getWildcardProjection() != null) {
            index.append("wildcardProjection", Assertions.assertNotNull(request.getWildcardProjection()));
        }
        if (request.isHidden()) {
            index.append("hidden", BsonBoolean.TRUE);
        }
        return index;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument("createIndexes", new BsonString(this.namespace.getCollectionName()));
            ArrayList<BsonDocument> values = new ArrayList<BsonDocument>();
            for (IndexRequest request : this.requests) {
                values.add(this.getIndex(request));
            }
            command.put("indexes", new BsonArray(values));
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command);
            if (this.commitQuorum != null) {
                if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
                    command.put("commitQuorum", this.commitQuorum.toBsonValue());
                } else {
                    throw new MongoClientException("Specifying a value for the create index commit quorum option requires a minimum MongoDB version of 4.4");
                }
            }
            return command;
        };
    }

    @Nullable
    private MongoException translateException(@Nullable Throwable t) {
        return t instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)t) : MongoException.fromThrowable(t);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException e) {
        if (ErrorCategory.fromErrorCode(e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(e.getResponse(), e.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return e;
    }
}

