/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonTimestamp;
import io.github.insideranh.stellarprotect.libs.bson.RawBsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncCommandBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ChangeStreamBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ChangeStreamOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.NonNull;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final TimeoutContext timeoutContext;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private final AtomicReference<AsyncCommandBatchCursor<RawBsonDocument>> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncCommandBatchCursor<RawBsonDocument> wrapped, AsyncReadBinding binding, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = new AtomicReference<AsyncCommandBatchCursor<RawBsonDocument>>(Assertions.assertNotNull(wrapped));
        this.binding = binding;
        binding.retain();
        this.timeoutContext = binding.getOperationContext().getTimeoutContext();
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.isClosed = new AtomicBoolean();
    }

    @NonNull
    AsyncCommandBatchCursor<RawBsonDocument> getWrapped() {
        return Assertions.assertNotNull(this.wrapped.get());
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(AsyncBatchCursor::next, callback, false);
    }

    @Override
    public void close() {
        this.timeoutContext.resetTimeoutIfPresent();
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.nullifyAndCloseWrapped();
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.getWrapped().setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.getWrapped().getBatchSize();
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed.get()) {
            return true;
        }
        if (this.wrappedClosedItself()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean wrappedClosedItself() {
        AsyncAggregateResponseBatchCursor observedWrapped = this.wrapped.get();
        return observedWrapped != null && observedWrapped.isClosed();
    }

    private void nullifyAndCloseWrapped() {
        AsyncAggregateResponseBatchCursor observedWrapped = this.wrapped.getAndSet(null);
        if (observedWrapped != null) {
            observedWrapped.close();
        }
    }

    private void setWrappedOrCloseIt(AsyncCommandBatchCursor<RawBsonDocument> newValue) {
        if (this.isClosed()) {
            Assertions.assertNull(this.wrapped.get());
            newValue.close();
        } else {
            Assertions.assertNull(this.wrapped.getAndSet(newValue));
            if (this.isClosed()) {
                this.nullifyAndCloseWrapped();
            }
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.getWrapped().getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.getWrapped().isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncCommandBatchCursor<RawBsonDocument> cursor) {
        BsonDocument resumeToken = cursor.getPostBatchResumeToken();
        if (resumeToken != null) {
            this.resumeToken = resumeToken;
        }
    }

    private void resumeableOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, boolean tryNext) {
        this.timeoutContext.resetTimeoutIfPresent();
        SingleResultCallback<List<Object>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        if (this.isClosed()) {
            errHandlingCallback.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", tryNext ? "tryNext()" : "next()")));
            return;
        }
        AsyncCommandBatchCursor<RawBsonDocument> wrappedCursor = this.getWrapped();
        asyncBlock.apply(wrappedCursor, (result, t) -> {
            if (t == null) {
                try {
                    List<T> convertedResults;
                    try {
                        convertedResults = ChangeStreamBatchCursor.convertAndProduceLastId(Assertions.assertNotNull(result), this.changeStreamOperation.getDecoder(), lastId -> {
                            this.resumeToken = lastId;
                        });
                    }
                    finally {
                        this.cachePostBatchResumeToken(wrappedCursor);
                    }
                    errHandlingCallback.onResult(convertedResults, null);
                }
                catch (Exception e) {
                    errHandlingCallback.onResult(null, e);
                }
            } else {
                this.cachePostBatchResumeToken(wrappedCursor);
                if (ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    this.nullifyAndCloseWrapped();
                    this.retryOperation(asyncBlock, errHandlingCallback, tryNext);
                } else {
                    errHandlingCallback.onResult(null, t);
                }
            }
        });
    }

    private void retryOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, boolean tryNext) {
        AsyncOperationHelper.withAsyncReadConnectionSource(this.binding, (source, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, Assertions.assertNotNull(source).getServerDescription().getMaxWireVersion());
                source.release();
                this.changeStreamOperation.executeAsync(this.binding, (asyncBatchCursor, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        try {
                            this.setWrappedOrCloseIt(Assertions.assertNotNull((AsyncChangeStreamBatchCursor)asyncBatchCursor).getWrapped());
                        }
                        finally {
                            try {
                                this.binding.release();
                            }
                            finally {
                                this.resumeableOperation(asyncBlock, callback, tryNext);
                            }
                        }
                    }
                });
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

