/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.event;

import io.github.insideranh.stellarprotect.libs.mongodb.event.ConnectionCheckOutFailedEvent;
import io.github.insideranh.stellarprotect.libs.mongodb.event.ConnectionClosedEvent;

public final class EventReasonMessageResolver {
    private static final String MESSAGE_CONNECTION_POOL_WAS_CLOSED = "Connection pool was closed";
    private static final String EMPTY_REASON = "";

    public static String getMessage(ConnectionClosedEvent.Reason reason) {
        switch (reason) {
            case STALE: {
                return "Connection became stale because the pool was cleared";
            }
            case IDLE: {
                return "Connection has been available but unused for longer than the configured max idle time";
            }
            case ERROR: {
                return "An error occurred while using the connection";
            }
            case POOL_CLOSED: {
                return MESSAGE_CONNECTION_POOL_WAS_CLOSED;
            }
        }
        return EMPTY_REASON;
    }

    public static String getMessage(ConnectionCheckOutFailedEvent.Reason reason) {
        switch (reason) {
            case TIMEOUT: {
                return "Wait queue timeout elapsed without a connection becoming available";
            }
            case CONNECTION_ERROR: {
                return "An error occurred while trying to establish a new connection";
            }
            case POOL_CLOSED: {
                return MESSAGE_CONNECTION_POOL_WAS_CLOSED;
            }
        }
        return EMPTY_REASON;
    }

    private EventReasonMessageResolver() {
    }
}

