/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinaryReader;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.io.ByteBufferBsonInput;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoInternalException;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ResponseBuffers;

public class ReplyMessage<T> {
    private final T document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        if (requestId != (long)responseBuffers.getReplyHeader().getResponseTo()) {
            throw new MongoInternalException(String.format("The responseTo (%d) in the response does not match the requestId (%d) in the request", responseBuffers.getReplyHeader().getResponseTo(), requestId));
        }
        try (ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer().duplicate());
             BsonBinaryReader reader = new BsonBinaryReader(bsonInput);){
            this.document = decoder.decode(reader, DecoderContext.builder().build());
        }
        finally {
            responseBuffers.reset();
        }
    }

    public T getDocument() {
        return this.document;
    }
}

