/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import java.util.concurrent.atomic.AtomicLong;

class ExponentiallyWeightedMovingAverage {
    private static final long EMPTY = -1L;
    private final double alpha;
    private final AtomicLong average;

    ExponentiallyWeightedMovingAverage(double alpha) {
        Assertions.isTrueArgument("alpha >= 0.0 and <= 1.0", alpha >= 0.0 && alpha <= 1.0);
        this.alpha = alpha;
        this.average = new AtomicLong(-1L);
    }

    void reset() {
        this.average.set(-1L);
    }

    long addSample(long sample) {
        return this.average.accumulateAndGet(sample, (average, givenSample) -> {
            if (average == -1L) {
                return givenSample;
            }
            return (long)(this.alpha * (double)givenSample + (1.0 - this.alpha) * (double)average);
        });
    }

    long getAverage() {
        long average = this.average.get();
        return average == -1L ? 0L : average;
    }
}

