/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.AuthenticationMechanism;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoSecurityException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerApi;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Authenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ScramShaAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SpeculativeAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

class DefaultAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
    private Authenticator delegate;

    DefaultAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        try {
            this.setDelegate(connectionDescription);
            this.delegate.authenticate(connection, connectionDescription, operationContext);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> callback) {
        this.setDelegate(connectionDescription);
        this.delegate.authenticateAsync(connection, connectionDescription, operationContext, callback);
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        this.delegate = this.getAuthenticatorForHello();
        return ((SpeculativeAuthenticator)((Object)this.delegate)).createSpeculativeAuthenticateCommand(connection);
    }

    @Override
    @Nullable
    public BsonDocument getSpeculativeAuthenticateResponse() {
        if (this.delegate != null) {
            return ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse();
        }
        return null;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        ((SpeculativeAuthenticator)((Object)this.delegate)).setSpeculativeAuthenticateResponse(response);
    }

    Authenticator getAuthenticatorForHello() {
        return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_256), this.getClusterConnectionMode(), this.getServerApi());
    }

    private void setDelegate(ConnectionDescription connectionDescription) {
        if (this.delegate != null && ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse() != null) {
            return;
        }
        if (connectionDescription.getSaslSupportedMechanisms() != null) {
            BsonArray saslSupportedMechs = connectionDescription.getSaslSupportedMechanisms();
            AuthenticationMechanism mechanism = saslSupportedMechs.contains(DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(mechanism), this.getClusterConnectionMode(), this.getServerApi());
        } else {
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi());
        }
    }

    private MongoException wrapException(Throwable t) {
        if (t instanceof MongoSecurityException) {
            return (MongoSecurityException)t;
        }
        if (t instanceof MongoException && ((MongoException)t).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), t);
        }
        return Assertions.assertNotNull(MongoException.fromThrowable(t));
    }
}

