/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.connection.SocketSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SslSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AsynchronousSocketChannelStreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import io.github.insideranh.stellarprotect.libs.mongodb.spi.dns.InetAddressResolver;
import java.nio.channels.AsynchronousChannelGroup;

public final class AsynchronousSocketChannelStreamFactoryFactory
implements StreamFactoryFactory {
    private final InetAddressResolver inetAddressResolver;
    @Nullable
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver) {
        this(inetAddressResolver, null);
    }

    AsynchronousSocketChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver, @Nullable AsynchronousChannelGroup group) {
        this.inetAddressResolver = inetAddressResolver;
        this.group = group;
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new AsynchronousSocketChannelStreamFactory(this.inetAddressResolver, socketSettings, sslSettings, this.group);
    }

    @Override
    public void close() {
        if (this.group != null) {
            this.group.shutdown();
        }
    }
}

