/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.bulk;

import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientUpdateResult;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.Optional;

public final class ConcreteClientUpdateResult
implements ClientUpdateResult {
    private final long matchedCount;
    private final long modifiedCount;
    @Nullable
    private final BsonValue upsertedId;

    public ConcreteClientUpdateResult(long matchedCount, long modifiedCount, @Nullable BsonValue upsertedId) {
        this.matchedCount = matchedCount;
        this.modifiedCount = modifiedCount;
        this.upsertedId = upsertedId;
    }

    @Override
    public long getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public long getModifiedCount() {
        return this.modifiedCount;
    }

    @Override
    public Optional<BsonValue> getUpsertedId() {
        return Optional.ofNullable(this.upsertedId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcreteClientUpdateResult that = (ConcreteClientUpdateResult)o;
        return this.matchedCount == that.matchedCount && this.modifiedCount == that.modifiedCount && Objects.equals(this.upsertedId, that.upsertedId);
    }

    public int hashCode() {
        return Objects.hash(this.matchedCount, this.modifiedCount, this.upsertedId);
    }

    public String toString() {
        return "ClientUpdateResult{matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ", upsertedId=" + this.upsertedId + '}';
    }
}

