/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.bulk;

import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientBulkWriteResult;
import java.util.Objects;
import java.util.Optional;

public final class AcknowledgedSummaryClientBulkWriteResult
implements ClientBulkWriteResult {
    private final long insertedCount;
    private final long upsertedCount;
    private final long matchedCount;
    private final long modifiedCount;
    private final long deletedCount;

    public AcknowledgedSummaryClientBulkWriteResult(long insertedCount, long upsertedCount, long matchedCount, long modifiedCount, long deletedCount) {
        this.insertedCount = insertedCount;
        this.upsertedCount = upsertedCount;
        this.matchedCount = matchedCount;
        this.modifiedCount = modifiedCount;
        this.deletedCount = deletedCount;
    }

    @Override
    public boolean isAcknowledged() {
        return true;
    }

    @Override
    public long getInsertedCount() {
        return this.insertedCount;
    }

    @Override
    public long getUpsertedCount() {
        return this.upsertedCount;
    }

    @Override
    public long getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public long getModifiedCount() {
        return this.modifiedCount;
    }

    @Override
    public long getDeletedCount() {
        return this.deletedCount;
    }

    @Override
    public Optional<ClientBulkWriteResult.VerboseResults> getVerboseResults() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedSummaryClientBulkWriteResult that = (AcknowledgedSummaryClientBulkWriteResult)o;
        return this.insertedCount == that.insertedCount && this.upsertedCount == that.upsertedCount && this.matchedCount == that.matchedCount && this.modifiedCount == that.modifiedCount && this.deletedCount == that.deletedCount;
    }

    public int hashCode() {
        return Objects.hash(this.insertedCount, this.upsertedCount, this.matchedCount, this.modifiedCount, this.deletedCount);
    }

    public String toString() {
        return "AcknowledgedSummaryClientBulkWriteResult{insertedCount=" + this.insertedCount + ", upsertedCount=" + this.upsertedCount + ", matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ", deletedCount=" + this.deletedCount + '}';
    }
}

