/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.mongodb.Function;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.FieldSearchPath;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.SearchPath;
import java.util.Iterator;

public final class Util {
    public static final String SEARCH_PATH_VALUE_KEY = "value";

    public static BsonValue combineToBsonValue(Iterator<? extends SearchPath> nonEmptyPaths, boolean valueOnly) {
        Function<SearchPath, BsonValue> toBsonValueFunc = valueOnly ? path -> {
            if (path instanceof FieldSearchPath) {
                return new BsonString(((FieldSearchPath)path).toValue());
            }
            return path.toBsonValue();
        } : SearchPath::toBsonValue;
        BsonValue firstPath = toBsonValueFunc.apply(nonEmptyPaths.next());
        if (nonEmptyPaths.hasNext()) {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(firstPath);
            while (nonEmptyPaths.hasNext()) {
                bsonArray.add(toBsonValueFunc.apply(nonEmptyPaths.next()));
            }
            return bsonArray;
        }
        return firstPath;
    }

    public static boolean sizeAtLeast(Iterable<?> iterable, int minInclusive) {
        int size;
        Iterator<?> iter = iterable.iterator();
        for (size = 0; size < minInclusive && iter.hasNext(); ++size) {
            iter.next();
        }
        return size >= minInclusive;
    }

    private Util() {
        throw Assertions.fail();
    }
}

