/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.capi;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocumentWrapper;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.AutoEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.AwsCredential;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.ConnectionString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoConfigurationException;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.authentication.AwsCredentialHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.authentication.AzureCredentialHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.authentication.GcpCredentialHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.crypt.capi.MongoCryptOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class MongoCryptHelper {
    public static MongoCryptOptions createMongoCryptOptions(ClientEncryptionSettings settings) {
        return MongoCryptHelper.createMongoCryptOptions(settings.getKmsProviders(), false, Collections.emptyList(), Collections.emptyMap(), null, null, settings.getKeyExpiration(TimeUnit.MILLISECONDS));
    }

    public static MongoCryptOptions createMongoCryptOptions(AutoEncryptionSettings settings) {
        return MongoCryptHelper.createMongoCryptOptions(settings.getKmsProviders(), settings.isBypassQueryAnalysis(), settings.isBypassAutoEncryption() ? Collections.emptyList() : Collections.singletonList("$SYSTEM"), settings.getExtraOptions(), settings.getSchemaMap(), settings.getEncryptedFieldsMap(), settings.getKeyExpiration(TimeUnit.MILLISECONDS));
    }

    public static void validateRewrapManyDataKeyOptions(RewrapManyDataKeyOptions options) {
        if (options.getMasterKey() != null && options.getProvider() == null) {
            throw new MongoClientException("Missing the provider but supplied a master key in the RewrapManyDataKeyOptions");
        }
    }

    private static MongoCryptOptions createMongoCryptOptions(Map<String, Map<String, Object>> kmsProviders, boolean bypassQueryAnalysis, List<String> searchPaths, @Nullable Map<String, Object> extraOptions, @Nullable Map<String, BsonDocument> localSchemaMap, @Nullable Map<String, BsonDocument> encryptedFieldsMap, @Nullable Long keyExpirationMS) {
        MongoCryptOptions.Builder mongoCryptOptionsBuilder = MongoCryptOptions.builder();
        mongoCryptOptionsBuilder.kmsProviderOptions(MongoCryptHelper.getKmsProvidersAsBsonDocument(kmsProviders));
        mongoCryptOptionsBuilder.bypassQueryAnalysis(bypassQueryAnalysis);
        mongoCryptOptionsBuilder.searchPaths(searchPaths);
        mongoCryptOptionsBuilder.extraOptions(MongoCryptHelper.toBsonDocument(extraOptions));
        mongoCryptOptionsBuilder.localSchemaMap(localSchemaMap);
        mongoCryptOptionsBuilder.encryptedFieldsMap(encryptedFieldsMap);
        mongoCryptOptionsBuilder.needsKmsCredentialsStateEnabled(true);
        mongoCryptOptionsBuilder.keyExpirationMS(keyExpirationMS);
        return mongoCryptOptionsBuilder.build();
    }

    public static BsonDocument fetchCredentials(Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        AwsCredential awsCredential;
        BsonDocument kmsProvidersDocument = MongoCryptHelper.getKmsProvidersAsBsonDocument(kmsProviders);
        for (Map.Entry<String, Supplier<Map<String, Object>>> entry : kmsProviderPropertySuppliers.entrySet()) {
            Map<String, Object> kmsProviderCredential;
            String kmsProviderName = entry.getKey();
            if (!kmsProvidersDocument.get(kmsProviderName).asDocument().isEmpty()) continue;
            try {
                kmsProviderCredential = entry.getValue().get();
            }
            catch (Exception e) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier.", kmsProviderName), e);
            }
            if (kmsProviderCredential == null || kmsProviderCredential.isEmpty()) {
                throw new MongoConfigurationException(String.format("Exception getting credential for kms provider %s from configured Supplier. The returned value is %s.", kmsProviderName, kmsProviderCredential == null ? "null" : "empty"));
            }
            kmsProvidersDocument.put(kmsProviderName, MongoCryptHelper.toBsonDocument(kmsProviderCredential));
        }
        if (kmsProvidersDocument.containsKey("aws") && kmsProvidersDocument.get("aws").asDocument().isEmpty() && (awsCredential = AwsCredentialHelper.obtainFromEnvironment()) != null) {
            BsonDocument awsCredentialDocument = new BsonDocument();
            awsCredentialDocument.put("accessKeyId", new BsonString(awsCredential.getAccessKeyId()));
            awsCredentialDocument.put("secretAccessKey", new BsonString(awsCredential.getSecretAccessKey()));
            if (awsCredential.getSessionToken() != null) {
                awsCredentialDocument.put("sessionToken", new BsonString(awsCredential.getSessionToken()));
            }
            kmsProvidersDocument.put("aws", awsCredentialDocument);
        }
        if (kmsProvidersDocument.containsKey("gcp") && kmsProvidersDocument.get("gcp").asDocument().isEmpty()) {
            kmsProvidersDocument.put("gcp", GcpCredentialHelper.obtainFromEnvironment());
        }
        if (kmsProvidersDocument.containsKey("azure") && kmsProvidersDocument.get("azure").asDocument().isEmpty()) {
            kmsProvidersDocument.put("azure", AzureCredentialHelper.obtainFromEnvironment());
        }
        return kmsProvidersDocument;
    }

    private static BsonDocument getKmsProvidersAsBsonDocument(Map<String, Map<String, Object>> kmsProviders) {
        BsonDocument bsonKmsProviders = new BsonDocument();
        kmsProviders.forEach((k, v) -> bsonKmsProviders.put((String)k, MongoCryptHelper.toBsonDocument(v)));
        return bsonKmsProviders;
    }

    private static BsonDocument toBsonDocument(@Nullable Map<String, Object> optionsMap) {
        if (optionsMap == null) {
            return new BsonDocument();
        }
        return new BsonDocumentWrapper<Document>(new Document(optionsMap), new DocumentCodec());
    }

    public static boolean isMongocryptdSpawningDisabled(@Nullable String cryptSharedLibVersion, AutoEncryptionSettings settings) {
        boolean cryptSharedLibIsAvailable = cryptSharedLibVersion != null && !cryptSharedLibVersion.isEmpty();
        boolean cryptSharedLibRequired = (Boolean)settings.getExtraOptions().getOrDefault("cryptSharedLibRequired", false);
        return settings.isBypassAutoEncryption() || settings.isBypassQueryAnalysis() || cryptSharedLibRequired || cryptSharedLibIsAvailable;
    }

    public static List<String> createMongocryptdSpawnArgs(Map<String, Object> options) {
        ArrayList<String> spawnArgs = new ArrayList<String>();
        String path = options.containsKey("mongocryptdSpawnPath") ? (String)options.get("mongocryptdSpawnPath") : "mongocryptd";
        spawnArgs.add(path);
        if (options.containsKey("mongocryptdSpawnArgs")) {
            spawnArgs.addAll((List)options.get("mongocryptdSpawnArgs"));
        }
        if (!spawnArgs.contains("--idleShutdownTimeoutSecs")) {
            spawnArgs.add("--idleShutdownTimeoutSecs");
            spawnArgs.add("60");
        }
        return spawnArgs;
    }

    public static MongoClientSettings createMongocryptdClientSettings(@Nullable String connectionString) {
        return MongoClientSettings.builder().applyToClusterSettings(builder -> builder.serverSelectionTimeout(10L, TimeUnit.SECONDS)).applyToSocketSettings(builder -> {
            builder.readTimeout(10L, TimeUnit.SECONDS);
            builder.connectTimeout(10L, TimeUnit.SECONDS);
        }).applyConnectionString(new ConnectionString(connectionString != null ? connectionString : "mongodb://localhost:27020")).build();
    }

    public static ProcessBuilder createProcessBuilder(Map<String, Object> options) {
        return new ProcessBuilder(MongoCryptHelper.createMongocryptdSpawnArgs(options));
    }

    public static void startProcess(ProcessBuilder processBuilder) {
        try {
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null"));
            processBuilder.start();
        }
        catch (Throwable t) {
            throw new MongoClientException("Exception starting mongocryptd process. Is `mongocryptd` on the system path?", t);
        }
    }

    private MongoCryptHelper() {
    }
}

