/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.binding;

import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AbstractReferenceCounted;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncConnectionSource;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AsyncConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Server;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.selector.ReadPreferenceServerSelector;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.selector.ServerAddressSelector;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.selector.WritableServerSelector;
import io.github.insideranh.stellarprotect.libs.mongodb.selector.ServerSelector;
import java.util.concurrent.TimeUnit;

public class AsyncClusterBinding
extends AbstractReferenceCounted
implements AsyncClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final OperationContext operationContext;

    public AsyncClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, OperationContext operationContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.operationContext = Assertions.notNull("operationContext", operationContext);
    }

    @Override
    public AsyncClusterAwareReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ReadPreferenceServerSelector(this.readPreference), callback);
    }

    @Override
    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            this.getReadConnectionSource(callback);
        } else {
            ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
            this.cluster.selectServerAsync(readPreferenceWithFallbackServerSelector, this.operationContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), readPreferenceWithFallbackServerSelector.getAppliedReadPreference()), null);
                }
            });
        }
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new WritableServerSelector(), callback);
    }

    @Override
    public void getConnectionSource(ServerAddress serverAddress, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getAsyncClusterBindingConnectionSource(new ServerAddressSelector(serverAddress), callback);
    }

    private void getAsyncClusterBindingConnectionSource(ServerSelector serverSelector, SingleResultCallback<AsyncConnectionSource> callback) {
        this.cluster.selectServerAsync(serverSelector, this.operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(new AsyncClusterBindingConnectionSource(result.getServer(), result.getServerDescription(), this.readPreference), null);
            }
        });
    }

    private final class AsyncClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements AsyncConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private AsyncClusterBindingConnectionSource(Server server, ServerDescription serverDescription, ReadPreference appliedReadPreference) {
            this.server = server;
            this.serverDescription = serverDescription;
            this.appliedReadPreference = appliedReadPreference;
            AsyncClusterBinding.this.operationContext.getTimeoutContext().minRoundTripTimeMS(TimeUnit.NANOSECONDS.toMillis(serverDescription.getMinRoundTripTimeNanos()));
            AsyncClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public OperationContext getOperationContext() {
            return AsyncClusterBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.server.getConnectionAsync(AsyncClusterBinding.this.operationContext, callback);
        }

        @Override
        public AsyncConnectionSource retain() {
            super.retain();
            AsyncClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            AsyncClusterBinding.this.release();
            return count;
        }
    }
}

