/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.time.Timeout;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class TimeoutHelper {
    private static final String DEFAULT_TIMEOUT_MESSAGE = "Operation exceeded the timeout limit.";

    private TimeoutHelper() {
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, String message, @Nullable Timeout timeout) {
        if (timeout != null) {
            return timeout.call(TimeUnit.MILLISECONDS, () -> collection.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> collection.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoCollection)TimeoutContext.throwMongoTimeoutException(message));
        }
        return collection;
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(collection, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, String message, @Nullable Timeout timeout) {
        if (timeout != null) {
            return timeout.call(TimeUnit.MILLISECONDS, () -> database.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> database.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoDatabase)TimeoutContext.throwMongoTimeoutException(message));
        }
        return database;
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeout(database, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }
}

