/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.Crypt;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.CryptConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ConnectionSource;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Connection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = wrapped;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress));
    }

    @Override
    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            return new CryptConnection(this.wrapped.getConnection(), CryptBinding.this.crypt);
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public int release() {
            return this.wrapped.release();
        }
    }
}

