/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.RawBsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.AutoEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoOperationTimeoutException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoTimeoutException;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClient;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClients;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.TimeoutHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.capi.MongoCryptHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.crypt.capi.MongoCrypt;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.time.Timeout;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    private static final String TIMEOUT_ERROR_MESSAGE = "Command marker exceeded the timeout limit.";
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command, @Nullable Timeout operationTimeout) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
                catch (MongoOperationTimeoutException e) {
                    throw e;
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand, @Nullable Timeout operationTimeout) {
        Assertions.assertNotNull(this.client);
        MongoDatabase mongoDatabase = this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary());
        return TimeoutHelper.databaseWithTimeout(mongoDatabase, TIMEOUT_ERROR_MESSAGE, operationTimeout).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

