/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.gridfs;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.types.ObjectId;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoGridFSException;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ClientSession;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.gridfs.GridFSUploadStream;
import io.github.insideranh.stellarprotect.libs.mongodb.client.gridfs.model.GridFSFile;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.TimeoutHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.Locks;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.time.Timeout;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class GridFSUploadStreamImpl
extends GridFSUploadStream {
    public static final String TIMEOUT_MESSAGE = "The GridFS upload stream exceeded the timeout limit.";
    private final ClientSession clientSession;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<BsonDocument> chunksCollection;
    private final BsonValue fileId;
    private final String filename;
    private final int chunkSizeBytes;
    private final Document metadata;
    private byte[] buffer;
    private long lengthInBytes;
    private int bufferOffset;
    private int chunkIndex;
    @Nullable
    private final Timeout timeout;
    private final ReentrantLock closeLock = new ReentrantLock();
    private boolean closed = false;

    GridFSUploadStreamImpl(@Nullable ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<BsonDocument> chunksCollection, BsonValue fileId, String filename, int chunkSizeBytes, @Nullable Document metadata, @Nullable Timeout timeout) {
        this.clientSession = clientSession;
        this.filesCollection = Assertions.notNull("files collection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunks collection", chunksCollection);
        this.fileId = Assertions.notNull("File Id", fileId);
        this.filename = Assertions.notNull("filename", filename);
        this.chunkSizeBytes = chunkSizeBytes;
        this.metadata = metadata;
        this.chunkIndex = 0;
        this.bufferOffset = 0;
        this.buffer = new byte[chunkSizeBytes];
        this.timeout = timeout;
    }

    @Override
    public ObjectId getObjectId() {
        if (!this.fileId.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS upload stream");
        }
        return this.fileId.asObjectId().getValue();
    }

    @Override
    public BsonValue getId() {
        return this.fileId;
    }

    @Override
    public void abort() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            this.checkClosed();
            this.closed = true;
        });
        if (this.clientSession != null) {
            GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).deleteMany(this.clientSession, new Document("files_id", this.fileId));
        } else {
            GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).deleteMany(new Document("files_id", this.fileId));
        }
    }

    @Override
    public void write(int b) {
        byte[] byteArray = new byte[]{(byte)(0xFF & b)};
        this.write(byteArray, 0, 1);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkClosed();
        this.checkTimeout();
        Assertions.notNull("b", b);
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int currentOffset = off;
        int lengthToWrite = len;
        int amountToCopy = 0;
        while (lengthToWrite > 0) {
            amountToCopy = lengthToWrite;
            if (amountToCopy > this.chunkSizeBytes - this.bufferOffset) {
                amountToCopy = this.chunkSizeBytes - this.bufferOffset;
            }
            System.arraycopy(b, currentOffset, this.buffer, this.bufferOffset, amountToCopy);
            this.bufferOffset += amountToCopy;
            currentOffset += amountToCopy;
            lengthToWrite -= amountToCopy;
            this.lengthInBytes += (long)amountToCopy;
            if (this.bufferOffset != this.chunkSizeBytes) continue;
            this.writeChunk();
        }
    }

    private void checkTimeout() {
        Timeout.onExistsAndExpired(this.timeout, () -> TimeoutContext.throwMongoTimeoutException(TIMEOUT_MESSAGE));
    }

    @Override
    public void close() {
        boolean alreadyClosed = Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            boolean prevClosed = this.closed;
            this.closed = true;
            return prevClosed;
        });
        if (alreadyClosed) {
            return;
        }
        this.writeChunk();
        GridFSFile gridFSFile = new GridFSFile(this.fileId, this.filename, this.lengthInBytes, this.chunkSizeBytes, new Date(), this.metadata);
        if (this.clientSession != null) {
            GridFSUploadStreamImpl.withNullableTimeout(this.filesCollection, this.timeout).insertOne(this.clientSession, gridFSFile);
        } else {
            GridFSUploadStreamImpl.withNullableTimeout(this.filesCollection, this.timeout).insertOne(gridFSFile);
        }
        this.buffer = null;
    }

    private void writeChunk() {
        if (this.bufferOffset > 0) {
            if (this.clientSession != null) {
                GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).insertOne(this.clientSession, new BsonDocument("files_id", this.fileId).append("n", new BsonInt32(this.chunkIndex)).append("data", this.getData()));
            } else {
                GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).insertOne(new BsonDocument("files_id", this.fileId).append("n", new BsonInt32(this.chunkIndex)).append("data", this.getData()));
            }
            ++this.chunkIndex;
            this.bufferOffset = 0;
        }
    }

    private BsonBinary getData() {
        if (this.bufferOffset < this.chunkSizeBytes) {
            byte[] sizedBuffer = new byte[this.bufferOffset];
            System.arraycopy(this.buffer, 0, sizedBuffer, 0, this.bufferOffset);
            this.buffer = sizedBuffer;
        }
        return new BsonBinary(this.buffer);
    }

    private void checkClosed() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            if (this.closed) {
                throw new MongoGridFSException("The OutputStream has been closed");
            }
        });
    }

    private static <T> MongoCollection<T> withNullableTimeout(MongoCollection<T> collection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(collection, TIMEOUT_MESSAGE, timeout);
    }
}

