/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Alpha;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.NotThreadSafe;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class ClientEncryptionSettings {
    private final MongoClientSettings keyVaultMongoClientSettings;
    private final String keyVaultNamespace;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    @Nullable
    private final Long timeoutMS;
    @Nullable
    private final Long keyExpirationMS;

    public static Builder builder() {
        return new Builder();
    }

    public MongoClientSettings getKeyVaultMongoClientSettings() {
        return this.keyVaultMongoClientSettings;
    }

    public String getKeyVaultNamespace() {
        return this.keyVaultNamespace;
    }

    public Map<String, Map<String, Object>> getKmsProviders() {
        return Collections.unmodifiableMap(this.kmsProviders);
    }

    public Map<String, Supplier<Map<String, Object>>> getKmsProviderPropertySuppliers() {
        return Collections.unmodifiableMap(this.kmsProviderPropertySuppliers);
    }

    public Map<String, SSLContext> getKmsProviderSslContextMap() {
        return Collections.unmodifiableMap(this.kmsProviderSslContextMap);
    }

    @Nullable
    public Long getKeyExpiration(TimeUnit timeUnit) {
        return this.keyExpirationMS == null ? null : Long.valueOf(timeUnit.convert(this.keyExpirationMS, TimeUnit.MILLISECONDS));
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit timeUnit) {
        return this.timeoutMS == null ? null : Long.valueOf(timeUnit.convert(this.timeoutMS, TimeUnit.MILLISECONDS));
    }

    private ClientEncryptionSettings(Builder builder) {
        this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", builder.keyVaultMongoClientSettings);
        this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", builder.keyVaultNamespace);
        this.kmsProviders = Assertions.notNull("kmsProviders", builder.kmsProviders);
        this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", builder.kmsProviderPropertySuppliers);
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", builder.kmsProviderSslContextMap);
        this.timeoutMS = builder.timeoutMS;
        this.keyExpirationMS = builder.keyExpirationMS;
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings keyVaultMongoClientSettings;
        private String keyVaultNamespace;
        private Map<String, Map<String, Object>> kmsProviders;
        private Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers = new HashMap<String, Supplier<Map<String, Object>>>();
        private Map<String, SSLContext> kmsProviderSslContextMap = new HashMap<String, SSLContext>();
        @Nullable
        private Long timeoutMS;
        @Nullable
        private Long keyExpirationMS;

        public Builder keyVaultMongoClientSettings(MongoClientSettings keyVaultMongoClientSettings) {
            this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", keyVaultMongoClientSettings);
            return this;
        }

        public Builder keyVaultNamespace(String keyVaultNamespace) {
            this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", keyVaultNamespace);
            return this;
        }

        public Builder kmsProviders(Map<String, Map<String, Object>> kmsProviders) {
            this.kmsProviders = Assertions.notNull("kmsProviders", kmsProviders);
            return this;
        }

        public Builder kmsProviderPropertySuppliers(Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
            this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", kmsProviderPropertySuppliers);
            return this;
        }

        public Builder kmsProviderSslContextMap(Map<String, SSLContext> kmsProviderSslContextMap) {
            this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", kmsProviderSslContextMap);
            return this;
        }

        public Builder keyExpiration(@Nullable Long keyExpiration, TimeUnit timeUnit) {
            Assertions.assertTrue(keyExpiration == null || keyExpiration >= 0L, "keyExpiration must be >= 0 or null");
            this.keyExpirationMS = keyExpiration == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.convert(keyExpiration, timeUnit));
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder timeout(long timeout, TimeUnit timeUnit) {
            this.timeoutMS = TimeoutSettings.convertAndValidateTimeout(timeout, timeUnit);
            return this;
        }

        public ClientEncryptionSettings build() {
            return new ClientEncryptionSettings(this);
        }

        private Builder() {
        }
    }
}

