/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.NotThreadSafe;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class AutoEncryptionSettings {
    private final MongoClientSettings keyVaultMongoClientSettings;
    private final String keyVaultNamespace;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final Map<String, BsonDocument> schemaMap;
    private final Map<String, Object> extraOptions;
    private final boolean bypassAutoEncryption;
    private final Map<String, BsonDocument> encryptedFieldsMap;
    private final boolean bypassQueryAnalysis;
    @Nullable
    private final Long keyExpirationMS;

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public MongoClientSettings getKeyVaultMongoClientSettings() {
        return this.keyVaultMongoClientSettings;
    }

    public String getKeyVaultNamespace() {
        return this.keyVaultNamespace;
    }

    public Map<String, Map<String, Object>> getKmsProviders() {
        return Collections.unmodifiableMap(this.kmsProviders);
    }

    public Map<String, Supplier<Map<String, Object>>> getKmsProviderPropertySuppliers() {
        return Collections.unmodifiableMap(this.kmsProviderPropertySuppliers);
    }

    public Map<String, SSLContext> getKmsProviderSslContextMap() {
        return Collections.unmodifiableMap(this.kmsProviderSslContextMap);
    }

    public Map<String, BsonDocument> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public boolean isBypassAutoEncryption() {
        return this.bypassAutoEncryption;
    }

    @Nullable
    public Map<String, BsonDocument> getEncryptedFieldsMap() {
        return this.encryptedFieldsMap;
    }

    public boolean isBypassQueryAnalysis() {
        return this.bypassQueryAnalysis;
    }

    @Nullable
    public Long getKeyExpiration(TimeUnit timeUnit) {
        return this.keyExpirationMS == null ? null : Long.valueOf(timeUnit.convert(this.keyExpirationMS, TimeUnit.MILLISECONDS));
    }

    private AutoEncryptionSettings(Builder builder) {
        this.keyVaultMongoClientSettings = builder.keyVaultMongoClientSettings;
        this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", builder.keyVaultNamespace);
        this.kmsProviders = Assertions.notNull("kmsProviders", builder.kmsProviders);
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", builder.kmsProviderSslContextMap);
        this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", builder.kmsProviderPropertySuppliers);
        this.schemaMap = Assertions.notNull("schemaMap", builder.schemaMap);
        this.extraOptions = Assertions.notNull("extraOptions", builder.extraOptions);
        this.bypassAutoEncryption = builder.bypassAutoEncryption;
        this.encryptedFieldsMap = builder.encryptedFieldsMap;
        this.bypassQueryAnalysis = builder.bypassQueryAnalysis;
        this.keyExpirationMS = builder.keyExpirationMS;
    }

    public String toString() {
        return "AutoEncryptionSettings{<hidden>}";
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings keyVaultMongoClientSettings;
        private String keyVaultNamespace;
        private Map<String, Map<String, Object>> kmsProviders;
        private Map<String, SSLContext> kmsProviderSslContextMap = new HashMap<String, SSLContext>();
        private Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers = new HashMap<String, Supplier<Map<String, Object>>>();
        private Map<String, BsonDocument> schemaMap = Collections.emptyMap();
        private Map<String, Object> extraOptions = Collections.emptyMap();
        private boolean bypassAutoEncryption;
        private Map<String, BsonDocument> encryptedFieldsMap = Collections.emptyMap();
        private boolean bypassQueryAnalysis;
        @Nullable
        private Long keyExpirationMS;

        public Builder keyVaultMongoClientSettings(MongoClientSettings keyVaultMongoClientSettings) {
            this.keyVaultMongoClientSettings = keyVaultMongoClientSettings;
            return this;
        }

        public Builder keyVaultNamespace(String keyVaultNamespace) {
            this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", keyVaultNamespace);
            return this;
        }

        public Builder kmsProviders(Map<String, Map<String, Object>> kmsProviders) {
            this.kmsProviders = Assertions.notNull("kmsProviders", kmsProviders);
            return this;
        }

        public Builder kmsProviderPropertySuppliers(Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
            this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", kmsProviderPropertySuppliers);
            return this;
        }

        public Builder kmsProviderSslContextMap(Map<String, SSLContext> kmsProviderSslContextMap) {
            this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", kmsProviderSslContextMap);
            return this;
        }

        public Builder schemaMap(Map<String, BsonDocument> schemaMap) {
            this.schemaMap = Assertions.notNull("schemaMap", schemaMap);
            return this;
        }

        public Builder extraOptions(Map<String, Object> extraOptions) {
            this.extraOptions = Assertions.notNull("extraOptions", extraOptions);
            return this;
        }

        public Builder bypassAutoEncryption(boolean bypassAutoEncryption) {
            this.bypassAutoEncryption = bypassAutoEncryption;
            return this;
        }

        public Builder encryptedFieldsMap(Map<String, BsonDocument> encryptedFieldsMap) {
            this.encryptedFieldsMap = Assertions.notNull("encryptedFieldsMap", encryptedFieldsMap);
            return this;
        }

        public Builder bypassQueryAnalysis(boolean bypassQueryAnalysis) {
            this.bypassQueryAnalysis = bypassQueryAnalysis;
            return this;
        }

        public Builder keyExpiration(@Nullable Long keyExpiration, TimeUnit timeUnit) {
            Assertions.assertTrue(keyExpiration == null || keyExpiration >= 0L, "keyExpiration must be >= 0 or null");
            this.keyExpirationMS = keyExpiration == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.convert(keyExpiration, timeUnit));
            return this;
        }

        public AutoEncryptionSettings build() {
            return new AutoEncryptionSettings(this);
        }

        private Builder() {
        }
    }
}

