/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.jol.info;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

abstract class AbstractGraphWalker {
    private static final ReferenceFieldsClassValue CLASS_REFERENCE_FIELDS = new ReferenceFieldsClassValue();

    AbstractGraphWalker() {
    }

    protected void verifyRoots(Object ... roots) {
        if (roots == null) {
            throw new IllegalArgumentException("Roots are null");
        }
        for (Object root : roots) {
            if (root != null) continue;
            throw new IllegalArgumentException("Some root is null");
        }
    }

    protected Field[] getAllReferenceFields(Class<?> cl) {
        return (Field[])CLASS_REFERENCE_FIELDS.get(cl);
    }

    private static class ReferenceFieldsClassValue
    extends ClassValue<Field[]> {
        private ReferenceFieldsClassValue() {
        }

        @Override
        protected Field[] computeValue(Class<?> klass) {
            Field[] fArr;
            ArrayList<Field> results = new ArrayList<Field>();
            for (Field f : klass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                results.add(f);
            }
            Class<?> superKlass = klass;
            while ((superKlass = superKlass.getSuperclass()) != null) {
                for (Field f : superKlass.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                    results.add(f);
                }
            }
            for (Field f : fArr = results.toArray(new Field[0])) {
                try {
                    f.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fArr;
        }
    }
}

