/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.json;

import io.github.insideranh.stellarprotect.libs.bson.json.Converter;
import io.github.insideranh.stellarprotect.libs.bson.json.ExtendedJsonDoubleConverter;
import io.github.insideranh.stellarprotect.libs.bson.json.StrictJsonWriter;

class RelaxedExtendedJsonDoubleConverter
implements Converter<Double> {
    private static final Converter<Double> FALLBACK_CONVERTER = new ExtendedJsonDoubleConverter();

    RelaxedExtendedJsonDoubleConverter() {
    }

    @Override
    public void convert(Double value, StrictJsonWriter writer) {
        if (value.isNaN() || value.isInfinite()) {
            FALLBACK_CONVERTER.convert(value, writer);
        } else {
            writer.writeNumber(Double.toString(value));
        }
    }
}

