/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinarySubType;
import io.github.insideranh.stellarprotect.libs.bson.BsonInvalidOperationException;
import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.Float32BinaryVector;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;

final class Float32BinaryVectorCodec
implements Codec<Float32BinaryVector> {
    Float32BinaryVectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, Float32BinaryVector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public Float32BinaryVector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asFloat32Vector();
    }

    @Override
    public Class<Float32BinaryVector> getEncoderClass() {
        return Float32BinaryVector.class;
    }
}

