/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson;

import io.github.insideranh.stellarprotect.libs.bson.BinaryVector;
import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import java.util.Arrays;
import java.util.Objects;

public final class Int8BinaryVector
extends BinaryVector {
    private byte[] data;

    Int8BinaryVector(byte[] data) {
        super(BinaryVector.DataType.INT8);
        this.data = Assertions.assertNotNull(data);
    }

    public byte[] getData() {
        return Assertions.assertNotNull(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int8BinaryVector that = (Int8BinaryVector)o;
        return Objects.deepEquals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return "Int8Vector{data=" + Arrays.toString(this.data) + ", dataType=" + (Object)((Object)this.getDataType()) + '}';
    }
}

