/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players.chat;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.entity.Player;

public class PlayerCommandEntry
extends LogEntry {
    private final String command;
    private final byte type;

    public PlayerCommandEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.command = jsonObject.get("c").getAsString();
        this.type = jsonObject.get("t").getAsByte();
    }

    public PlayerCommandEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.command = jsonObject.get("c").getAsString();
        this.type = jsonObject.get("t").getAsByte();
    }

    public PlayerCommandEntry(long playerId, String command) {
        super(playerId, ActionType.COMMAND.getId(), 0, 0.0, 0.0, 0.0, System.currentTimeMillis());
        this.command = command;
        this.type = 0;
    }

    public PlayerCommandEntry(long playerId, Player player, String command) {
        super(playerId, ActionType.COMMAND.getId(), player.getLocation(), System.currentTimeMillis());
        this.command = command;
        this.type = 1;
    }

    @Override
    public String getDataString() {
        return this.command;
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerCommandEntry entry = this;
        obj.addProperty("c", entry.getCommand());
        obj.addProperty("t", (Number)entry.getType());
        return obj.toString();
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public byte getType() {
        return this.type;
    }
}

