/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerTransactionEntry
extends LogEntry {
    private Map<Long, Integer> added = new HashMap<Long, Integer>();
    private Map<Long, Integer> removed = new HashMap<Long, Integer>();

    public PlayerTransactionEntry(Document document, JsonObject jsonObject) {
        super(document);
        int amount;
        String base64Key;
        if (jsonObject.has("ai")) {
            JsonObject addedItemsObj = jsonObject.get("ai").getAsJsonObject();
            for (Map.Entry entry : addedItemsObj.entrySet()) {
                base64Key = (String)entry.getKey();
                amount = ((JsonElement)entry.getValue()).getAsInt();
                this.added.put(Long.parseLong(base64Key), amount);
            }
        }
        if (jsonObject.has("ri")) {
            JsonObject removedItemsObj = jsonObject.get("ri").getAsJsonObject();
            for (Map.Entry entry : removedItemsObj.entrySet()) {
                base64Key = (String)entry.getKey();
                amount = ((JsonElement)entry.getValue()).getAsInt();
                this.removed.put(Long.parseLong(base64Key), amount);
            }
        }
    }

    public PlayerTransactionEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        int amount;
        String base64Key;
        if (jsonObject.has("ai")) {
            JsonObject addedItemsObj = jsonObject.get("ai").getAsJsonObject();
            for (Map.Entry entry : addedItemsObj.entrySet()) {
                base64Key = (String)entry.getKey();
                amount = ((JsonElement)entry.getValue()).getAsInt();
                this.added.put(Long.parseLong(base64Key), amount);
            }
        }
        if (jsonObject.has("ri")) {
            JsonObject removedItemsObj = jsonObject.get("ri").getAsJsonObject();
            for (Map.Entry entry : removedItemsObj.entrySet()) {
                base64Key = (String)entry.getKey();
                amount = ((JsonElement)entry.getValue()).getAsInt();
                this.removed.put(Long.parseLong(base64Key), amount);
            }
        }
    }

    public PlayerTransactionEntry(long playerId, Map<Long, Integer> added, Map<Long, Integer> removed, Location location, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        this.added = added;
        this.removed = removed;
    }

    @Override
    public String getDataString() {
        return "added: " + this.added.toString() + ", removed: " + this.removed.toString();
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerTransactionEntry entry = this;
        JsonObject addedItemsObj = new JsonObject();
        for (Map.Entry<Long, Integer> addedItem : entry.getAdded().entrySet()) {
            addedItemsObj.addProperty(String.valueOf(addedItem.getKey()), (Number)addedItem.getValue());
        }
        JsonObject removedItemsObj = new JsonObject();
        for (Map.Entry<Long, Integer> removedItem : entry.getRemoved().entrySet()) {
            removedItemsObj.addProperty(String.valueOf(removedItem.getKey()), (Number)removedItem.getValue());
        }
        obj.add("ai", (JsonElement)addedItemsObj);
        obj.add("ri", (JsonElement)removedItemsObj);
        return obj.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlayerTransactionEntry that = (PlayerTransactionEntry)o;
        return Objects.equals(this.added, that.added) && Objects.equals(this.removed, that.removed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.added, this.removed);
    }

    @Generated
    public Map<Long, Integer> getAdded() {
        return this.added;
    }

    @Generated
    public Map<Long, Integer> getRemoved() {
        return this.removed;
    }
}

