/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.cache;

import io.github.insideranh.stellarprotect.items.ItemTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemsCache {
    private static final int CAPACITY = 8192;
    private static final int MASK = 8191;
    private static final float LOAD_FACTOR = 0.7f;
    private final ItemTemplate[] items = new ItemTemplate[8192];
    private final IndexEntry[] idIndex = new IndexEntry[8192];
    private final IndexEntry[] displayNameIndex = new IndexEntry[8192];
    private final IndexEntry[] loreIndex = new IndexEntry[8192];
    private final IndexEntry[] typeNameIndex = new IndexEntry[8192];
    private final Map<String, IntOpenHashSet> displayNameTokens = new HashMap<String, IntOpenHashSet>();
    private final Map<String, IntOpenHashSet> loreTokens = new HashMap<String, IntOpenHashSet>();
    private final Map<String, IntOpenHashSet> typeNameTokens = new HashMap<String, IntOpenHashSet>();
    private final int[] validPositions = new int[8192];
    private int validCount = 0;
    private int size = 0;

    private static long hash(String str) {
        int i;
        if (str == null) {
            return 0L;
        }
        long hash = 0L;
        int len = str.length();
        for (i = 0; i < len - 3; i += 4) {
            hash = (hash << 5) - hash + (long)str.charAt(i);
            hash = (hash << 5) - hash + (long)str.charAt(i + 1);
            hash = (hash << 5) - hash + (long)str.charAt(i + 2);
            hash = (hash << 5) - hash + (long)str.charAt(i + 3);
        }
        while (i < len) {
            hash = (hash << 5) - hash + (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    private static long hashLong(long value) {
        value = (value ^ 0xFFFFFFFFFFFFFFFFL) + (value << 18);
        value ^= value >>> 31;
        value *= 21L;
        value ^= value >>> 11;
        value += value << 6;
        value ^= value >>> 22;
        return value;
    }

    private void indexSubstrings(String text, Map<String, IntOpenHashSet> tokenMap, int position) {
        String[] words;
        if (text == null || text.isEmpty()) {
            return;
        }
        String lowerText = text.toLowerCase();
        for (int len = 2; len <= Math.min(6, lowerText.length()); ++len) {
            for (int i = 0; i <= lowerText.length() - len; ++i) {
                String substring = lowerText.substring(i, i + len);
                tokenMap.computeIfAbsent(substring, k -> new IntOpenHashSet()).add(position);
            }
        }
        for (String word : words = lowerText.split("\\s+")) {
            if (word.isEmpty()) continue;
            tokenMap.computeIfAbsent(word, k -> new IntOpenHashSet()).add(position);
        }
    }

    private int findFreePosition() {
        for (int i = 0; i < 8192; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        throw new IllegalStateException("Cache full");
    }

    private void addToStringIndex(IndexEntry[] index, String key, int position) {
        if (key == null) {
            return;
        }
        long hash = ItemsCache.hash(key);
        int slot = (int)(hash & 0x1FFFL);
        IndexEntry entry = new IndexEntry(hash, position);
        while (index[slot] != null) {
            if (index[slot].hash == hash) {
                entry.next = index[slot].next;
                index[slot] = entry;
                return;
            }
            slot = slot + 1 & 0x1FFF;
        }
        index[slot] = entry;
    }

    private void addToIdIndex(long id, int position) {
        long hash = ItemsCache.hashLong(id);
        int slot = (int)(hash & 0x1FFFL);
        IndexEntry entry = new IndexEntry(hash, position);
        while (this.idIndex[slot] != null) {
            if (this.idIndex[slot].hash == hash) {
                entry.next = this.idIndex[slot].next;
                this.idIndex[slot] = entry;
                return;
            }
            slot = slot + 1 & 0x1FFF;
        }
        this.idIndex[slot] = entry;
    }

    private ItemTemplate searchInStringIndex(IndexEntry[] index, String key) {
        if (key == null) {
            return null;
        }
        long hash = ItemsCache.hash(key);
        int slot = (int)(hash & 0x1FFFL);
        while (index[slot] != null) {
            ItemTemplate item;
            IndexEntry entry = index[slot];
            if (entry.hash == hash && (item = this.items[entry.position]) != null && (index == this.typeNameIndex && key.equals(item.getTypeName()) || index == this.loreIndex && key.equals(item.getLore()) || index == this.displayNameIndex && key.equals(item.getDisplayName()))) {
                return item;
            }
            slot = slot + 1 & 0x1FFF;
        }
        return null;
    }

    private ItemTemplate searchById(long id) {
        long hash = ItemsCache.hashLong(id);
        int slot = (int)(hash & 0x1FFFL);
        while (this.idIndex[slot] != null) {
            ItemTemplate item;
            IndexEntry entry = this.idIndex[slot];
            if (entry.hash == hash && (item = this.items[entry.position]) != null && item.id == id) {
                return item;
            }
            slot = slot + 1 & 0x1FFF;
        }
        return null;
    }

    private List<Long> findContains(String searchText, Map<String, IntOpenHashSet> tokenMap, FieldType fieldType) {
        if (searchText == null || searchText.isEmpty()) {
            return new ArrayList<Long>();
        }
        String lowerSearch = searchText.toLowerCase();
        ArrayList<Long> results = new ArrayList<Long>();
        IntOpenHashSet candidatePositions = tokenMap.get(lowerSearch);
        if (candidatePositions != null) {
            int[] positions;
            for (int pos : positions = candidatePositions.toArray()) {
                ItemTemplate item = this.items[pos];
                if (item == null) continue;
                results.add(item.id);
            }
            return results;
        }
        String bestMatch = null;
        IntOpenHashSet bestPositions = null;
        for (int len = Math.min(lowerSearch.length(), 6); len >= 2; --len) {
            for (int i = 0; i <= lowerSearch.length() - len; ++i) {
                String candidate = lowerSearch.substring(i, i + len);
                IntOpenHashSet positions = tokenMap.get(candidate);
                if (positions == null) continue;
                bestMatch = candidate;
                bestPositions = positions;
                break;
            }
            if (bestMatch != null) break;
        }
        if (bestPositions != null) {
            int[] positions;
            for (int pos : positions = bestPositions.toArray()) {
                String fieldValue;
                ItemTemplate item = this.items[pos];
                if (item == null || (fieldValue = this.getFieldValue(item, fieldType)) == null || !fieldValue.contains(lowerSearch)) continue;
                results.add(item.id);
            }
            return results;
        }
        for (int i = 0; i < this.validCount; ++i) {
            String fieldValue;
            int pos = this.validPositions[i];
            ItemTemplate item = this.items[pos];
            if (item == null || (fieldValue = this.getFieldValue(item, fieldType)) == null || !fieldValue.contains(lowerSearch)) continue;
            results.add(item.id);
        }
        return results;
    }

    private String getFieldValue(ItemTemplate item, FieldType fieldType) {
        switch (fieldType.ordinal()) {
            case 0: {
                return item.getDisplayName();
            }
            case 1: {
                return item.getLore();
            }
            case 2: {
                return item.getTypeName();
            }
            case 3: {
                return item.getDisplayNameLower();
            }
            case 4: {
                return item.getLoreLower();
            }
            case 5: {
                return item.getTypeNameLower();
            }
        }
        return null;
    }

    public boolean put(ItemTemplate item) {
        if ((float)this.size >= 5734.4f) {
            return false;
        }
        int position = this.findFreePosition();
        this.items[position] = item;
        this.validPositions[this.validCount++] = position;
        this.addToIdIndex(item.id, position);
        if (item.getDisplayName() != null) {
            this.addToStringIndex(this.displayNameIndex, item.getDisplayName(), position);
        }
        if (item.getLore() != null) {
            this.addToStringIndex(this.loreIndex, item.getLore(), position);
        }
        if (item.getTypeName() != null) {
            this.addToStringIndex(this.typeNameIndex, item.getTypeName(), position);
        }
        if (item.getDisplayName() != null) {
            this.indexSubstrings(item.getDisplayName(), this.displayNameTokens, position);
        }
        if (item.getLore() != null) {
            this.indexSubstrings(item.getLore(), this.loreTokens, position);
        }
        if (item.getTypeName() != null) {
            this.indexSubstrings(item.getTypeName(), this.typeNameTokens, position);
        }
        ++this.size;
        return true;
    }

    public ItemTemplate getById(long id) {
        return this.searchById(id);
    }

    public ItemTemplate getByDisplayNameExact(String displayName) {
        return this.searchInStringIndex(this.displayNameIndex, displayName);
    }

    public ItemTemplate getByLoreExact(String lore) {
        return this.searchInStringIndex(this.loreIndex, lore);
    }

    public ItemTemplate getByTypeNameExact(String typeName) {
        return this.searchInStringIndex(this.typeNameIndex, typeName);
    }

    public List<Long> findIdsByDisplayNameContains(String searchText) {
        return this.findContains(searchText, this.displayNameTokens, FieldType.LOWER_DISPLAY_NAME);
    }

    public List<Long> findIdsByLoreContains(String searchText) {
        return this.findContains(searchText, this.loreTokens, FieldType.LOWER_LORE);
    }

    public List<Long> findIdsByTypeNameContains(List<String> searchTexts, FieldType fieldType) {
        if (searchTexts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (String searchText : searchTexts) {
            result.addAll(this.findContains(searchText, this.typeNameTokens, fieldType));
        }
        return result;
    }

    public List<Long> findIdsContains(Map<String, List<String>> searchTexts) {
        if (searchTexts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        if (searchTexts.containsKey("material_type")) {
            result.addAll(this.findIdsByTypeNameContains(searchTexts.get("material_type"), FieldType.LOWER_TYPE_NAME));
        }
        if (searchTexts.containsKey("display")) {
            result.addAll(this.findIdsByTypeNameContains(searchTexts.get("display"), FieldType.LOWER_DISPLAY_NAME));
        }
        if (searchTexts.containsKey("lore")) {
            result.addAll(this.findIdsByTypeNameContains(searchTexts.get("lore"), FieldType.LOWER_LORE));
        }
        return result;
    }

    public ItemTemplate[] items() {
        return this.items;
    }

    public int size() {
        return this.size;
    }

    private static class IndexEntry {
        final long hash;
        final int position;
        IndexEntry next;

        IndexEntry(long hash, int position) {
            this.hash = hash;
            this.position = position;
        }
    }

    private static class IntOpenHashSet {
        private int[] keys;
        private boolean[] allocated;
        private int size;

        public IntOpenHashSet() {
            this(16);
        }

        public IntOpenHashSet(int capacity) {
            capacity = IntOpenHashSet.nextPowerOfTwo(capacity);
            this.keys = new int[capacity];
            this.allocated = new boolean[capacity];
            this.size = 0;
        }

        private static int nextPowerOfTwo(int n) {
            --n;
            n |= n >> 1;
            n |= n >> 2;
            n |= n >> 4;
            n |= n >> 8;
            n |= n >> 16;
            return n + 1;
        }

        public void add(int key) {
            float loadFactor = 0.75f;
            if ((float)this.size >= (float)this.keys.length * loadFactor) {
                this.resize();
            }
            int slot = key & this.keys.length - 1;
            while (this.allocated[slot]) {
                if (this.keys[slot] == key) {
                    return;
                }
                slot = slot + 1 & this.keys.length - 1;
            }
            this.keys[slot] = key;
            this.allocated[slot] = true;
            ++this.size;
        }

        public int[] toArray() {
            int[] result = new int[this.size];
            int idx = 0;
            for (int i = 0; i < this.allocated.length; ++i) {
                if (!this.allocated[i]) continue;
                result[idx++] = this.keys[i];
            }
            return result;
        }

        private void resize() {
            int[] oldKeys = this.keys;
            boolean[] oldAllocated = this.allocated;
            this.keys = new int[oldKeys.length * 2];
            this.allocated = new boolean[oldAllocated.length * 2];
            this.size = 0;
            for (int i = 0; i < oldAllocated.length; ++i) {
                if (!oldAllocated[i]) continue;
                this.add(oldKeys[i]);
            }
        }
    }

    public static enum FieldType {
        DISPLAY_NAME,
        LORE,
        TYPE_NAME,
        LOWER_DISPLAY_NAME,
        LOWER_LORE,
        LOWER_TYPE_NAME;

    }
}

