/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoWriteConcernException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcernResult;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BsonDocumentWrapperHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.stream.Collectors;

final class FindAndModifyHelper {
    static <T> SyncOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    static <T> AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    @Nullable
    private static <T> T transformDocument(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            throw new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument("lastErrorObject", new BsonDocument())), serverAddress, result.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet()));
        }
        if (!result.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

