/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;

public class CommandReadOperation<T>
implements AsyncReadOperation<T>,
ReadOperation<T> {
    private final String databaseName;
    private final CommandOperationHelper.CommandCreator commandCreator;
    private final Decoder<T> decoder;

    public CommandReadOperation(String databaseName, BsonDocument command, Decoder<T> decoder) {
        this(databaseName, (OperationContext operationContext, ServerDescription serverDescription, ConnectionDescription connectionDescription) -> command, decoder);
    }

    public CommandReadOperation(String databaseName, CommandOperationHelper.CommandCreator commandCreator, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.commandCreator = Assertions.notNull("commandCreator", commandCreator);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(ReadBinding binding) {
        return (T)SyncOperationHelper.executeRetryableRead(binding, this.databaseName, this.commandCreator, this.decoder, (result, source, connection) -> result, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<T> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.databaseName, this.commandCreator, this.decoder, (result, source, connection) -> result, false, callback);
    }
}

