/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.tlschannel;

import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.tlschannel.BufferAllocator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.tlschannel.TlsChannel;
import java.nio.channels.ByteChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;

public abstract class TlsChannelBuilder<T extends TlsChannelBuilder<T>> {
    final ByteChannel underlying;
    Consumer<SSLSession> sessionInitCallback = session -> {};
    boolean runTasks = true;
    BufferAllocator plainBufferAllocator = TlsChannel.defaultPlainBufferAllocator;
    BufferAllocator encryptedBufferAllocator = TlsChannel.defaultEncryptedBufferAllocator;
    boolean releaseBuffers = true;
    boolean waitForCloseConfirmation = false;

    TlsChannelBuilder(ByteChannel underlying) {
        this.underlying = underlying;
    }

    abstract T getThis();

    public T withRunTasks(boolean runTasks) {
        this.runTasks = runTasks;
        return this.getThis();
    }

    public T withPlainBufferAllocator(BufferAllocator bufferAllocator) {
        this.plainBufferAllocator = bufferAllocator;
        return this.getThis();
    }

    public T withEncryptedBufferAllocator(BufferAllocator bufferAllocator) {
        this.encryptedBufferAllocator = bufferAllocator;
        return this.getThis();
    }

    public T withSessionInitCallback(Consumer<SSLSession> sessionInitCallback) {
        this.sessionInitCallback = sessionInitCallback;
        return this.getThis();
    }

    public T withReleaseBuffers(boolean releaseBuffers) {
        this.releaseBuffers = releaseBuffers;
        return this.getThis();
    }

    public T withWaitForCloseConfirmation(boolean waitForCloseConfirmation) {
        this.waitForCloseConfirmation = waitForCloseConfirmation;
        return this.getThis();
    }
}

