/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.ByteBuf;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CommandMessage;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultConnectionPool;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ResponseBuffers;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Logger;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Loggers;
import java.util.List;

class UsageTrackingInternalConnection
implements InternalConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private volatile long openedAt;
    private volatile long lastUsedAt;
    private volatile boolean closeSilently;
    private final InternalConnection wrapped;
    private final DefaultConnectionPool.ServiceStateManager serviceStateManager;

    UsageTrackingInternalConnection(InternalConnection wrapped, DefaultConnectionPool.ServiceStateManager serviceStateManager) {
        this.wrapped = wrapped;
        this.serviceStateManager = serviceStateManager;
        this.lastUsedAt = this.openedAt = Long.MAX_VALUE;
    }

    @Override
    public void open(OperationContext operationContext) {
        this.wrapped.open(operationContext);
        this.lastUsedAt = this.openedAt = System.currentTimeMillis();
        if (this.getDescription().getServiceId() != null) {
            this.serviceStateManager.addConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
        }
    }

    @Override
    public void openAsync(OperationContext operationContext, SingleResultCallback<Void> callback) {
        this.wrapped.openAsync(operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                this.lastUsedAt = this.openedAt = System.currentTimeMillis();
                if (this.getDescription().getServiceId() != null) {
                    this.serviceStateManager.addConnection(this.getDescription().getServiceId());
                }
                callback.onResult(null, null);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.wrapped.close();
        }
        finally {
            if (this.openedAt != Long.MAX_VALUE && this.getDescription().getServiceId() != null) {
                this.serviceStateManager.removeConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
            }
        }
    }

    @Override
    public boolean opened() {
        return this.wrapped.opened();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.wrapped.getBuffer(size);
    }

    @Override
    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId, OperationContext operationContext) {
        this.wrapped.sendMessage(byteBuffers, lastRequestId, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, OperationContext operationContext) {
        T result = this.wrapped.sendAndReceive(message, decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return result;
    }

    @Override
    public <T> void send(CommandMessage message, Decoder<T> decoder, OperationContext operationContext) {
        this.wrapped.send(message, decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T receive(Decoder<T> decoder, OperationContext operationContext) {
        T result = this.wrapped.receive(decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return result;
    }

    @Override
    public boolean hasMoreToCome() {
        return this.wrapped.hasMoreToCome();
    }

    @Override
    public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult(result, t);
        }, LOGGER);
        this.wrapped.sendAndReceiveAsync(message, decoder, operationContext, errHandlingCallback);
    }

    @Override
    public ResponseBuffers receiveMessage(int responseTo, OperationContext operationContext) {
        ResponseBuffers responseBuffers = this.wrapped.receiveMessage(responseTo, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return responseBuffers;
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, OperationContext operationContext, SingleResultCallback<Void> callback) {
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult((Void)result, t);
        }, LOGGER);
        this.wrapped.sendMessageAsync(byteBuffers, lastRequestId, operationContext, errHandlingCallback);
    }

    @Override
    public void receiveMessageAsync(int responseTo, OperationContext operationContext, SingleResultCallback<ResponseBuffers> callback) {
        SingleResultCallback<ResponseBuffers> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult((ResponseBuffers)result, t);
        }, LOGGER);
        this.wrapped.receiveMessageAsync(responseTo, operationContext, errHandlingCallback);
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public ServerDescription getInitialServerDescription() {
        return this.wrapped.getInitialServerDescription();
    }

    @Override
    public int getGeneration() {
        return this.wrapped.getGeneration();
    }

    long getOpenedAt() {
        return this.openedAt;
    }

    long getLastUsedAt() {
        return this.lastUsedAt;
    }

    void setCloseSilently() {
        this.closeSilently = true;
    }

    boolean isCloseSilently() {
        return this.closeSilently;
    }
}

