/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.AsyncTransportSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.NettyTransportSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SocketSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SslSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.TransportSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AsynchronousSocketChannelStreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SocketStreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.TlsChannelStreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.netty.NettyStreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import io.github.insideranh.stellarprotect.libs.mongodb.spi.dns.InetAddressResolver;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;

public final class StreamFactoryHelper {
    public static StreamFactoryFactory getSyncStreamFactoryFactory(@Nullable TransportSettings transportSettings, final InetAddressResolver inetAddressResolver) {
        if (transportSettings == null) {
            return new StreamFactoryFactory(){

                @Override
                public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
                    return new SocketStreamFactory(inetAddressResolver, socketSettings, sslSettings);
                }

                @Override
                public void close() {
                }
            };
        }
        if (transportSettings instanceof AsyncTransportSettings) {
            throw new MongoClientException("Unsupported transport settings in sync: " + transportSettings.getClass().getName());
        }
        if (transportSettings instanceof NettyTransportSettings) {
            return StreamFactoryHelper.getNettyStreamFactoryFactory(inetAddressResolver, (NettyTransportSettings)transportSettings);
        }
        throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
    }

    public static StreamFactoryFactory getAsyncStreamFactoryFactory(MongoClientSettings settings, InetAddressResolver inetAddressResolver) {
        TransportSettings transportSettings = settings.getTransportSettings();
        if (transportSettings == null || transportSettings instanceof AsyncTransportSettings) {
            ExecutorService executorService;
            ExecutorService executorService2 = executorService = transportSettings == null ? null : ((AsyncTransportSettings)transportSettings).getExecutorService();
            if (settings.getSslSettings().isEnabled()) {
                return new TlsChannelStreamFactoryFactory(inetAddressResolver, executorService);
            }
            AsynchronousChannelGroup group = null;
            if (executorService != null) {
                try {
                    group = AsynchronousChannelGroup.withThreadPool(executorService);
                }
                catch (IOException e) {
                    throw new MongoClientException("Unable to create an asynchronous channel group", e);
                }
            }
            return new AsynchronousSocketChannelStreamFactoryFactory(inetAddressResolver, group);
        }
        if (transportSettings instanceof NettyTransportSettings) {
            return StreamFactoryHelper.getNettyStreamFactoryFactory(inetAddressResolver, (NettyTransportSettings)transportSettings);
        }
        throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
    }

    private static NettyStreamFactoryFactory getNettyStreamFactoryFactory(InetAddressResolver inetAddressResolver, NettyTransportSettings transportSettings) {
        return NettyStreamFactoryFactory.builder().applySettings(transportSettings).inetAddressResolver(inetAddressResolver).build();
    }

    private StreamFactoryHelper() {
    }
}

