/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.AuthenticationMechanism;
import io.github.insideranh.stellarprotect.libs.mongodb.LoggerSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCompressor;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoDriverInformation;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerApi;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerId;
import io.github.insideranh.stellarprotect.libs.mongodb.event.CommandListener;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Authenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AwsAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClientMetadataHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ConnectionGenerationSupplier;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.GSSAPIAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnectionFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalStreamConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalStreamConnectionInitializer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OidcAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.PlainAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ScramShaAuthenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.X509Authenticator;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this(clusterConnectionMode, false, streamFactory, credential, applicationName, mongoDriverInformation, compressorList, loggerSettings, commandListener, serverApi);
    }

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        InternalStreamConnectionInitializer connectionInitializer = new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadataDocument, this.compressorList, this.serverApi);
        return new InternalStreamConnection(this.clusterConnectionMode, authenticator, this.isMonitoringConnection, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.loggerSettings, this.commandListener, connectionInitializer);
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        AuthenticationMechanism authenticationMechanism = credential.getAuthenticationMechanism();
        if (authenticationMechanism == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (authenticationMechanism) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_OIDC: {
                return new OidcAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)authenticationMechanism));
    }
}

