/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.LoggerSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCompressor;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCredential;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoDriverInformation;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerApi;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionPoolSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerId;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.event.CommandListener;
import io.github.insideranh.stellarprotect.libs.mongodb.event.ServerListener;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterableServer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterableServerFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultConnectionFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultConnectionPool;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultServer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DefaultServerMonitor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalOperationContextFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalStreamConnectionFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SdamServerDescriptionManager;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.event.EventListenerHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.inject.SameObjectProvider;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final InternalOperationContextFactory clusterOperationContextFactory;
    private final StreamFactory streamFactory;
    private final InternalOperationContextFactory heartbeatOperationContextFactory;
    private final StreamFactory heartbeatStreamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;
    private final boolean isFunctionAsAServiceEnvironment;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, InternalOperationContextFactory clusterOperationContextFactory, StreamFactory streamFactory, InternalOperationContextFactory heartbeatOperationContextFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, boolean isFunctionAsAServiceEnvironment) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.clusterOperationContextFactory = clusterOperationContextFactory;
        this.streamFactory = streamFactory;
        this.heartbeatOperationContextFactory = heartbeatOperationContextFactory;
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.isFunctionAsAServiceEnvironment = isFunctionAsAServiceEnvironment;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, new InternalStreamConnectionFactory(clusterMode, true, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), this.loggerSettings, null, this.serverApi), clusterMode, this.serverApi, this.isFunctionAsAServiceEnvironment, sdamProvider, this.heartbeatOperationContextFactory);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider, this.clusterOperationContextFactory);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

