/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SocketSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SslSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AsynchronousSocketChannelStream;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.PowerOfTwoBufferPool;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Stream;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import io.github.insideranh.stellarprotect.libs.mongodb.spi.dns.InetAddressResolver;
import java.nio.channels.AsynchronousChannelGroup;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final InetAddressResolver inetAddressResolver;
    @Nullable
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings) {
        this(inetAddressResolver, settings, sslSettings, null);
    }

    AsynchronousSocketChannelStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings, @Nullable AsynchronousChannelGroup group) {
        Assertions.assertFalse(sslSettings.isEnabled());
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.inetAddressResolver, this.settings, this.bufferProvider, this.group);
    }
}

