/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.async;

import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import java.util.concurrent.atomic.AtomicBoolean;

@FunctionalInterface
public interface AsyncFunction<T, R> {
    public void unsafeFinish(T var1, SingleResultCallback<R> var2);

    default public void finish(T value, SingleResultCallback<R> callback) {
        AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            this.unsafeFinish(value, (v, e) -> {
                if (!callbackInvoked.compareAndSet(false, true)) {
                    throw new AssertionError(String.format("Callback has been already completed. It could happen if code throws an exception after invoking an async method. Value: %s", v), e);
                }
                callback.onResult(v, e);
            });
        }
        catch (Throwable t) {
            if (!callbackInvoked.compareAndSet(false, true)) {
                throw t;
            }
            callback.completeExceptionally(t);
        }
    }
}

