/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.event;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerId;
import java.util.concurrent.TimeUnit;

public final class ConnectionCheckOutFailedEvent {
    private final ServerId serverId;
    private final long operationId;
    private final Reason reason;
    private final long elapsedTimeNanos;

    public ConnectionCheckOutFailedEvent(ServerId serverId, long operationId, Reason reason, long elapsedTimeNanos) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.operationId = operationId;
        this.reason = Assertions.notNull("reason", reason);
        Assertions.isTrueArgument("waited time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    public ServerId getServerId() {
        return this.serverId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public Reason getReason() {
        return this.reason;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "ConnectionCheckOutFailedEvent{server=" + this.serverId.getAddress() + ", clusterId=" + this.serverId.getClusterId() + ", operationId=" + this.operationId + ", reason=" + (Object)((Object)this.reason) + ", elapsedTimeNanos=" + this.elapsedTimeNanos + '}';
    }

    public static enum Reason {
        POOL_CLOSED,
        TIMEOUT,
        CONNECTION_ERROR,
        UNKNOWN;

    }
}

