/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.result;

import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Objects;

public abstract class UpdateResult {
    public abstract boolean wasAcknowledged();

    public abstract long getMatchedCount();

    public abstract long getModifiedCount();

    @Nullable
    public abstract BsonValue getUpsertedId();

    public static UpdateResult acknowledged(long matchedCount, @Nullable Long modifiedCount, @Nullable BsonValue upsertedId) {
        return new AcknowledgedUpdateResult(matchedCount, modifiedCount, upsertedId);
    }

    public static UpdateResult unacknowledged() {
        return new UnacknowledgedUpdateResult();
    }

    private static class AcknowledgedUpdateResult
    extends UpdateResult {
        private final long matchedCount;
        private final Long modifiedCount;
        private final BsonValue upsertedId;

        AcknowledgedUpdateResult(long matchedCount, Long modifiedCount, @Nullable BsonValue upsertedId) {
            this.matchedCount = matchedCount;
            this.modifiedCount = modifiedCount;
            this.upsertedId = upsertedId;
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        public long getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public long getModifiedCount() {
            return this.modifiedCount;
        }

        @Override
        @Nullable
        public BsonValue getUpsertedId() {
            return this.upsertedId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedUpdateResult that = (AcknowledgedUpdateResult)o;
            if (this.matchedCount != that.matchedCount) {
                return false;
            }
            if (!Objects.equals(this.modifiedCount, that.modifiedCount)) {
                return false;
            }
            return Objects.equals(this.upsertedId, that.upsertedId);
        }

        public int hashCode() {
            int result = (int)(this.matchedCount ^ this.matchedCount >>> 32);
            result = 31 * result + (this.modifiedCount != null ? this.modifiedCount.hashCode() : 0);
            result = 31 * result + (this.upsertedId != null ? this.upsertedId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AcknowledgedUpdateResult{matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ", upsertedId=" + this.upsertedId + '}';
        }
    }

    private static class UnacknowledgedUpdateResult
    extends UpdateResult {
        private UnacknowledgedUpdateResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public long getMatchedCount() {
            throw this.getUnacknowledgedWriteException();
        }

        @Override
        public long getModifiedCount() {
            throw this.getUnacknowledgedWriteException();
        }

        @Override
        @Nullable
        public BsonValue getUpsertedId() {
            throw this.getUnacknowledgedWriteException();
        }

        private UnsupportedOperationException getUnacknowledgedWriteException() {
            return new UnsupportedOperationException("Cannot get information about an unacknowledged update");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedUpdateResult{}";
        }
    }
}

