/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.model.search;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Beta;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Sealed;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.DateSearchFacet;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.FieldSearchPath;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.NumberSearchFacet;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.StringSearchFacet;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.Util;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;

@Sealed
@Beta(value={Reason.CLIENT, Reason.SERVER})
public interface SearchFacet
extends Bson {
    public static StringSearchFacet stringFacet(String name, FieldSearchPath path) {
        return new SearchConstructibleBsonElement(Assertions.notNull("name", name), (Bson)new Document("type", "string").append("path", Assertions.notNull("path", path).toValue()));
    }

    public static NumberSearchFacet numberFacet(String name, FieldSearchPath path, Iterable<? extends Number> boundaries) {
        Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(boundaries, 2));
        return new SearchConstructibleBsonElement(Assertions.notNull("name", name), (Bson)new Document("type", "number").append("path", Assertions.notNull("path", path).toValue()).append("boundaries", Assertions.notNull("boundaries", boundaries)));
    }

    public static DateSearchFacet dateFacet(String name, FieldSearchPath path, Iterable<Instant> boundaries) {
        Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(boundaries, 2));
        return new SearchConstructibleBsonElement(Assertions.notNull("name", name), (Bson)new Document("type", "date").append("path", Assertions.notNull("path", path).toValue()).append("boundaries", Assertions.notNull("boundaries", boundaries)));
    }

    public static SearchFacet of(Bson facet) {
        return new SearchConstructibleBsonElement(Assertions.notNull("facet", facet));
    }

    public static Bson combineToBson(final Iterable<? extends SearchFacet> facets) {
        Assertions.notNull("facets", facets);
        Assertions.isTrueArgument("facets must not be empty", Util.sizeAtLeast(facets, 1));
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                HashSet<String> names = new HashSet<String>();
                BsonDocument result = new BsonDocument();
                for (SearchFacet facet : facets) {
                    BsonDocument doc = facet.toBsonDocument(documentClass, codecRegistry);
                    Assertions.assertTrue(doc.size() == 1);
                    Map.Entry<String, BsonValue> entry = doc.entrySet().iterator().next();
                    String name = entry.getKey();
                    Assertions.isTrue(String.format("facet names must be unique. '%s' is used at least twice in %s", names, facets), names.add(name));
                    result.append(name, entry.getValue());
                }
                return result;
            }

            public String toString() {
                return facets.toString();
            }
        };
    }
}

