/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonNull;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.bson.internal.BsonUtil;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientEncryptionSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoConfigurationException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoUpdatedEncryptedFieldsException;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.bulk.BulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.FindIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClient;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClients;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.Crypt;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.Crypts;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.TimeoutHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.CreateCollectionOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.CreateEncryptedCollectionParams;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Filters;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.UpdateOneModel;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Updates;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.vault.DataKeyOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.vault.EncryptOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.vault.RewrapManyDataKeyResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.result.DeleteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.vault.ClientEncryption;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.capi.MongoCryptHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.time.Timeout;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this(MongoClients.create(options.getKeyVaultMongoClientSettings()), options);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options);
        this.options = options;
        MongoNamespace namespace = new MongoNamespace(options.getKeyVaultNamespace());
        this.collection = ClientEncryptionImpl.getVaultCollection(keyVaultClient, options, namespace);
    }

    private static MongoCollection<BsonDocument> getVaultCollection(MongoClient keyVaultClient, ClientEncryptionSettings options, MongoNamespace namespace) {
        MongoCollection<BsonDocument> vaultCollection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
        Long timeoutMs = options.getTimeout(TimeUnit.MILLISECONDS);
        if (timeoutMs != null) {
            vaultCollection = vaultCollection.withTimeout(timeoutMs, TimeUnit.MILLISECONDS);
        }
        return vaultCollection;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        Timeout operationTimeout = this.startTimeout();
        return this.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
    }

    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions, @Nullable Timeout operationTimeout) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
        TimeoutHelper.collectionWithTimeout(this.collection, "Data key insertion exceeded the timeout limit.", operationTimeout).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.encryptExplicitly(value, options, operationTimeout);
    }

    @Override
    public BsonDocument encryptExpression(Bson expression, EncryptOptions options) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.encryptExpression(expression.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options, operationTimeout);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.decryptExplicitly(value, operationTimeout);
    }

    @Override
    public DeleteResult deleteKey(BsonBinary id) {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).deleteOne(Filters.eq("_id", id));
    }

    @Override
    public BsonDocument getKey(BsonBinary id) {
        return (BsonDocument)TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find(Filters.eq("_id", id)).first();
    }

    @Override
    public FindIterable<BsonDocument> getKeys() {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find();
    }

    @Override
    public BsonDocument addKeyAltName(BsonBinary id, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Updates.addToSet("keyAltNames", keyAltName));
    }

    @Override
    public BsonDocument removeKeyAltName(BsonBinary id, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Collections.singletonList(updateDocument));
    }

    @Override
    public BsonDocument getKeyByAltName(String keyAltName) {
        return (BsonDocument)this.collection.find(Filters.eq("keyAltNames", keyAltName)).first();
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter) {
        return this.rewrapManyDataKey(filter, new RewrapManyDataKeyOptions());
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter, RewrapManyDataKeyOptions options) {
        MongoCryptHelper.validateRewrapManyDataKeyOptions(options);
        Timeout operationTimeout = this.startTimeout();
        BsonDocument results = this.crypt.rewrapManyDataKey(filter.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options, operationTimeout);
        if (results.isEmpty()) {
            return new RewrapManyDataKeyResult();
        }
        List updateModels = results.getArray("v", new BsonArray()).stream().map(v -> {
            BsonDocument updateDocument = v.asDocument();
            return new UpdateOneModel(Filters.eq(updateDocument.get("_id")), Updates.combine(Updates.set("masterKey", updateDocument.get("masterKey")), Updates.set("keyMaterial", updateDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
        }).collect(Collectors.toList());
        BulkWriteResult bulkWriteResult = TimeoutHelper.collectionWithTimeout(this.collection, operationTimeout).bulkWrite(updateModels);
        return new RewrapManyDataKeyResult(bulkWriteResult);
    }

    @Override
    public BsonDocument createEncryptedCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull("collectionName", collectionName);
        Assertions.notNull("createCollectionOptions", createCollectionOptions);
        Assertions.notNull("createEncryptedCollectionParams", createEncryptedCollectionParams);
        Timeout operationTimeout = this.startTimeout();
        MongoNamespace namespace = new MongoNamespace(database.getName(), collectionName);
        Bson rawEncryptedFields = createCollectionOptions.getEncryptedFields();
        if (rawEncryptedFields == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", namespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument encryptedFields = rawEncryptedFields.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue fields = encryptedFields.get("fields");
        if (fields != null && fields.isArray()) {
            String kmsProvider = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument masterKey = createEncryptedCollectionParams.getMasterKey();
            if (masterKey != null) {
                dataKeyOptions.masterKey(masterKey);
            }
            String keyIdBsonKey = "keyId";
            BsonDocument maybeUpdatedEncryptedFields = BsonUtil.mutableDeepCopy(encryptedFields);
            AtomicBoolean dataKeyMightBeCreated = new AtomicBoolean();
            try {
                maybeUpdatedEncryptedFields.get("fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(field -> field.containsKey(keyIdBsonKey)).filter(field -> Objects.equals(field.get(keyIdBsonKey), BsonNull.VALUE)).forEachOrdered(field -> {
                    dataKeyMightBeCreated.set(true);
                    BsonBinary dataKeyId = this.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
                    field.put(keyIdBsonKey, dataKeyId);
                });
                TimeoutHelper.databaseWithTimeout(database, operationTimeout).createCollection(collectionName, new CreateCollectionOptions(createCollectionOptions).encryptedFields(maybeUpdatedEncryptedFields));
                return maybeUpdatedEncryptedFields;
            }
            catch (Exception e) {
                if (dataKeyMightBeCreated.get()) {
                    throw new MongoUpdatedEncryptedFieldsException(maybeUpdatedEncryptedFields, String.format("Failed to create %s.", namespace), (Throwable)e);
                }
                throw e;
            }
        }
        TimeoutHelper.databaseWithTimeout(database, operationTimeout).createCollection(collectionName, createCollectionOptions);
        return encryptedFields;
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }

    @Nullable
    private Timeout startTimeout() {
        return TimeoutContext.startTimeout(this.options.getTimeout(TimeUnit.MILLISECONDS));
    }
}

