/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoServerException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteError;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.bulk.WriteConcernError;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientBulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ClientBulkWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ClientBulkWriteException
extends MongoServerException {
    private static final long serialVersionUID = 1L;
    private final List<WriteConcernError> writeConcernErrors;
    private final Map<Integer, WriteError> writeErrors;
    @Nullable
    private final ClientBulkWriteResult partialResult;

    public ClientBulkWriteException(@Nullable MongoException error, @Nullable List<WriteConcernError> writeConcernErrors, @Nullable Map<Integer, WriteError> writeErrors, @Nullable ClientBulkWriteResult partialResult, ServerAddress serverAddress) {
        super(ClientBulkWriteException.message(error, writeConcernErrors, writeErrors, partialResult, Assertions.notNull("serverAddress", serverAddress)), ClientBulkWriteException.validateServerAddress(error, serverAddress));
        this.initCause(error);
        Assertions.isTrueArgument("At least one of `writeConcernErrors`, `writeErrors`, `partialResult` must be non-null or non-empty", writeConcernErrors != null && !writeConcernErrors.isEmpty() || writeErrors != null && !writeErrors.isEmpty() || partialResult != null);
        this.writeConcernErrors = writeConcernErrors == null ? Collections.emptyList() : Collections.unmodifiableList(writeConcernErrors);
        this.writeErrors = writeErrors == null ? Collections.emptyMap() : Collections.unmodifiableMap(writeErrors);
        this.partialResult = partialResult;
    }

    private static String message(@Nullable MongoException error, @Nullable List<WriteConcernError> writeConcernErrors, @Nullable Map<Integer, WriteError> writeErrors, @Nullable ClientBulkWriteResult partialResult, ServerAddress serverAddress) {
        return "Client-level bulk write operation error on server " + serverAddress + "." + (error == null ? "" : " Top-level error: " + error + ".") + (writeErrors == null || writeErrors.isEmpty() ? "" : " Write errors: " + writeErrors + ".") + (writeConcernErrors == null || writeConcernErrors.isEmpty() ? "" : " Write concern errors: " + writeConcernErrors + ".") + (partialResult == null ? "" : " Partial result: " + partialResult + ".");
    }

    private static ServerAddress validateServerAddress(@Nullable MongoException error, ServerAddress serverAddress) {
        ClientBulkWriteOperation.Exceptions.serverAddressFromException(error).ifPresent(serverAddressFromError -> Assertions.isTrueArgument("`serverAddress` must be equal to that of the `error`", serverAddressFromError.equals(serverAddress)));
        return error instanceof MongoServerException ? ((MongoServerException)error).getServerAddress() : serverAddress;
    }

    @Override
    @Nullable
    public MongoException getCause() {
        return (MongoException)super.getCause();
    }

    public List<WriteConcernError> getWriteConcernErrors() {
        return this.writeConcernErrors;
    }

    public Map<Integer, WriteError> getWriteErrors() {
        return this.writeErrors;
    }

    public Optional<ClientBulkWriteResult> getPartialResult() {
        return Optional.ofNullable(this.partialResult);
    }
}

